﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_ApplicationVersionSystemApi.h>
#include <nn/sf/sf_Types.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {

    void RequestVersionList() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationVersionInterface()->RequestVersionList());
    }

    void PerformAutoUpdate() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationVersionInterface()->PerformAutoUpdate());
    }

    Result UpdateVersionList(const char* buffer, size_t size) NN_NOEXCEPT
    {
        return GetApplicationVersionInterface()->UpdateVersionList(sf::InBuffer(buffer, size));
    }

    void PushLaunchVersion(ncm::ApplicationId id, uint32_t version) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationVersionInterface()->PushLaunchVersion(id, version));
    }

    int ListRequiredVersion(RequiredVersionEntry* outValue, int count) NN_NOEXCEPT
    {
        int outCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationVersionInterface()->ListRequiredVersion(&outCount, sf::OutArray<RequiredVersionEntry>(outValue, count)));
        return outCount;
    }

    int ListVersionList(VersionListEntry* outValue, int count) NN_NOEXCEPT
    {
        int outCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationVersionInterface()->ListVersionList(&outCount, sf::OutArray<VersionListEntry>(outValue, count)));
        return outCount;
    }

    Result RequestVersionListData(AsyncVersionListData* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncValue> sp;
        NN_RESULT_DO(GetApplicationVersionInterface()->RequestVersionListData(&nativeHandle, &sp));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();
        NN_RESULT_SUCCESS;
    }

    uint32_t GetLaunchRequiredVersion(ncm::ApplicationId targetApp) NN_NOEXCEPT
    {
        uint32_t requiredVersion;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationVersionInterface()->GetLaunchRequiredVersion(&requiredVersion, targetApp));
        return requiredVersion;
    }

    void UpgradeLaunchRequiredVersion(ncm::ApplicationId targetApp, uint32_t launchRequiredVersion) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationVersionInterface()->UpgradeLaunchRequiredVersion(targetApp, launchRequiredVersion));
    }
}}

