﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_ApplicationContentMetaApi.h>
#include <nn/ns/ns_ApplicationContentMetaSystemApi.h>
#include <nn/sf/sf_Types.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {
    Result CountApplicationContentMeta(int* outValue, ncm::ApplicationId appId) NN_NOEXCEPT
    {
        return GetContentManagementInterface()->CountApplicationContentMeta(outValue, appId);
    }

    Result ListApplicationContentMetaStatus(int* outCount, ApplicationContentMetaStatus outList[], int count, ncm::ApplicationId appId, int offset) NN_NOEXCEPT
    {
        return GetContentManagementInterface()->ListApplicationContentMetaStatus(outCount, sf::OutArray<ApplicationContentMetaStatus>(outList, static_cast<size_t>(count)), appId, offset);
    }

    Result ListApplicationContentMetaStatusWithRightsCheck(int* outCount, ApplicationContentMetaStatus outList[], int count, ncm::ApplicationId appId, int offset) NN_NOEXCEPT
    {
        return GetContentManagementInterface()->ListApplicationContentMetaStatusWithRightsCheck(outCount, sf::OutArray<ApplicationContentMetaStatus>(outList, static_cast<size_t>(count)), appId, offset);
    }

    Result ListAvailableAddOnContent(int* outCount, ApplicationContentMetaStatus outList[], int count, ncm::ApplicationId appId, int offset) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ListAvailableAddOnContent(outCount, sf::OutArray<ApplicationContentMetaStatus>(outList, static_cast<size_t>(count)), appId, offset);
    }

    Result GetOwnedApplicationContentMetaStatus(ApplicationContentMetaStatus* outValue, ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetOwnedApplicationContentMetaStatus(outValue, appId, contentMetaId);
    }

    Result RegisterContentsExternalKey(ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->RegisterContentsExternalKey(appId, contentMetaId);
    }

    Result GetContentMetaStorage(ncm::StorageId* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetContentMetaStorage(outValue, key);
    }
}}

