﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_RetailInteractiveDisplayApi.h>

#include "ns_Initialize.h"

namespace nn { namespace ns {

    Result CreateUserAccount(account::Nickname name, void* image, size_t imageSize) NN_NOEXCEPT
    {
        sf::InBuffer buffer(static_cast<char*>(image), imageSize);
        NN_RESULT_DO(GetAccountProxyInterface()->CreateUserAccount(name, buffer));

        NN_RESULT_SUCCESS;
    }
}}
