﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/nn_ApplicationId.h>")]
    public struct ApplicationId
    {
    }

    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/nn_TimeSpan.h>")]
    public struct TimeSpanType
    {
    }
}

namespace nn.npns
{
    [ExternalStruct(40, 8)]
    [CppRefPath("<nn/npns/npns_Types.h>")]
    public struct NotificationToken
    {
    }
}

namespace nn.account
{
    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/account/account_Types.h>")]
    public struct Uid
    {
    }
}

namespace nn.npns
{
    [CppRefPath(@"<nn/npns/npns_INpns.sfdl.h>")]
    public interface INpnsUser : IServiceObject
    {
        [MethodId(1)]
        Result ListenAll();

        [MethodId(2)]
        Result ListenTo(ApplicationId toId);

        [MethodId(3)]
        Result Receive(nn.sf.OutBuffer outBuffer, uint16_t version);

        [MethodId(4)]
        Result ReceiveRaw(nn.sf.OutBuffer outBuffer, uint16_t version);

        [MethodId(5)]
        Result GetReceiveEvent(nn.sf.Out<NativeHandle> outHandle);

        [MethodId(7)]
        Result GetStateChangeEvent(nn.sf.Out<NativeHandle> outHandle);

        [MethodId(21)]
        Result CreateToken(nn.sf.Out<NotificationToken> outToken, nn.account.Uid uid, [ProcessId] Bit64 processId);

        [MethodId(23)]
        Result DestroyToken(nn.account.Uid uid, [ProcessId] Bit64 processId);

        [MethodId(25)]
        Result QueryIsTokenValid(nn.sf.Out<bool> bResult, NotificationToken token);

        [MethodId(26)]
        Result ListenToMyApplicationId([ProcessId] Bit64 processId);

        [MethodId(101)]
        Result Suspend();

        [MethodId(102)]
        Result Resume();

        [MethodId(103)]
        Result GetState(nn.sf.Out<std.int32_t> outState);

        [MethodId(104)]
        Result GetStatistics(nn.sf.OutBuffer outStatistics);

        [MethodId(111)]
        Result GetJid(nn.sf.OutArray<char_t> jid);
    }

    [CppRefPath(@"<nn/npns/npns_INpns.sfdl.h>")]
    public interface INpnsSystem : INpnsUser
    {
        [MethodId(6)]
        Result ListenUndelivered();

        [MethodId(11)]
        Result SubscribeTopic(nn.sf.InArray<char_t> name);

        [MethodId(12)]
        Result UnsubscribeTopic(nn.sf.InArray<char_t> name);

        [MethodId(13)]
        Result QueryIsTopicExist(nn.sf.Out<bool> bResult, nn.sf.InArray<char_t> name);

        [MethodId(22)]
        Result CreateTokenWithApplicationId(nn.sf.Out<NotificationToken> outToken, nn.account.Uid uid, ApplicationId applicationId);

        [MethodId(24)]
        Result DestroyTokenWithApplicationId(nn.account.Uid uid, ApplicationId applicationId);

        [MethodId(31)]
        Result UploadTokenToBaaS(nn.account.Uid uid);

        [MethodId(32)]
        Result DestroyTokenForBaaS(nn.account.Uid uid);

        [MethodId(105)]
        Result GetPlayReportRequestEvent(nn.sf.Out<NativeHandle> outHandle);

        [MethodId(112)]
        Result CreateJid();

        [MethodId(113)]
        Result DestroyJid();

        [MethodId(114)]
        Result AttachJid(nn.sf.InArray<char_t> jid, nn.sf.InArray<char_t> password);

        [MethodId(115)]
        Result DetachJid(nn.sf.OutArray<char_t> jid, nn.sf.OutArray<char_t> password);

        // for test only.
        [MethodId(201)]
        Result RequestChangeStateForceTimed(int32_t targetState, nn.TimeSpanType timeout);

        [MethodId(202)]
        Result RequestChangeStateForceAsync(int32_t targetState);
    }
}
