﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_ISharedObject.h>
#include <nn/npns/npns_INpns.sfdl.h>
#include <nn/npns/detail/npns_HipcPorts.h>

namespace nn { namespace npns {

Result CreateDfcProxy(PortIndex portIndex) NN_NOEXCEPT;
Result CreateHipcProxy(PortIndex portIndex) NN_NOEXCEPT;
void DestroyServiceProxy(PortIndex portIndex) NN_NOEXCEPT;

INpnsUser& GetServiceProxyUser() NN_NOEXCEPT;
INpnsSystem& GetServiceProxySystem() NN_NOEXCEPT;

}}
