﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include "nim_ResultMappingUtil.h"

namespace nn { namespace nim { namespace srv {

Result MapTaskResult(Result result) NN_NOEXCEPT
{
    NN_RESULT_TRY(result)
        NN_RESULT_CATCH_CONVERT(ncm::ResultSdCardContentMetaDatabaseNotActive, ResultSdCardNotActive())
        NN_RESULT_CATCH_CONVERT(ncm::ResultSdCardContentStorageNotActive, ResultSdCardNotActive())
    NN_RESULT_END_TRY

    NN_RESULT_SUCCESS;
}

}}}
