﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ncm/ncm_Service.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/srv/nim_NetworkSystemUpdateTask.h>
#include <nn/nim/detail/nim_Log.h>

namespace nn { namespace nim { namespace srv {

    Result NetworkSystemUpdateTask::Initialize(DeviceContext* deviceContext, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT
    {
        m_Key = key;
        NN_RESULT_DO(m_Data.Initialize(dataFilePath));
        NN_RESULT_DO(NetworkInstallTaskBase::Initialize(deviceContext, ncm::StorageId::BuildInSystem, &m_Data, true, config));

        NN_RESULT_SUCCESS;
    }

    Result NetworkSystemUpdateTask::GetApplyInfo(ncm::SystemUpdateTaskApplyInfo* outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(m_Data.GetSystemUpdateTaskApplyInfo(outValue));
        NN_RESULT_SUCCESS;
    }

    int NetworkSystemUpdateTask::CountInstallContentMetaKey() NN_NOEXCEPT
    {
        return 1;
    }

    Result NetworkSystemUpdateTask::GetInstallContentMetaKey(ncm::ContentMetaKey* outValue, int index) NN_NOEXCEPT
    {
        NN_UNUSED(index);
        *outValue = m_Key;
        NN_RESULT_SUCCESS;
    }

    Result NetworkSystemUpdateTask::InstallTicket(const nn::fs::RightsId&, nn::ncm::ContentMetaType) NN_NOEXCEPT
    {
        NN_RESULT_THROW(ResultNotSupported());
    }

    Result NetworkSystemUpdateTask::GetDownloadedSystemDataPath(ncm::Path* outValue, ncm::SystemDataId id) NN_NOEXCEPT
    {
        NN_RESULT_TRY(GetPreparedPlaceHolderPath(outValue, id.value, ncm::ContentMetaType::SystemData, ncm::ContentType::Data))
            NN_RESULT_CATCH(ncm::ResultPlaceHolderNotFound) { NN_RESULT_THROW(ResultSystemDataNotFound()); }
        NN_RESULT_END_TRY

        NN_RESULT_SUCCESS;
    }
    Result NetworkSystemUpdateTask::PrepareDependency() NN_NOEXCEPT
    {
        ncm::SystemUpdateTaskApplyInfo info;
        NN_RESULT_DO(ncm::InstallTaskBase::GetSystemUpdateTaskApplyInfo(&info));
        NN_SDK_ASSERT(info != ncm::SystemUpdateTaskApplyInfo::CannotJudgeYet);
        NN_RESULT_DO(m_Data.SetSystemUpdateTaskApplyInfo(info));

        NN_RESULT_DO(PrepareSystemUpdateDependency());
        NN_RESULT_SUCCESS;
    }

}}}
