﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nim/srv/nim_NetworkInstallTaskHolder.h>

namespace nn { namespace nim { namespace srv {

    Result SystemUpdateTaskHolder::Initialize(DeviceContext* deviceContext, const util::Uuid& uuid, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->Initialize(deviceContext, key, config, dataFilePath))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    SystemUpdateTaskInfo SystemUpdateTaskHolder::GetInfo() NN_NOEXCEPT
    {
        SystemUpdateTaskInfo info = { m_Task->GetProgress(), m_Task->GetKey() };

        auto throughput = m_Task->GetThroughput();
        info.downloaded = throughput.installed;
        info.elapsedTime = throughput.elapsedTime;
        NN_ABORT_UNLESS_RESULT_SUCCESS(m_Task->GetApplyInfo(&info.applyInfo));
        return info;
    }

    Result NetworkInstallTaskHolder::Initialize(DeviceContext* deviceContext, DeviceAccountStore* deviceAccountStore, const util::Uuid& uuid, const char* metaFilePath, const char* dataFilePath, ovln::SenderForOverlayType* sender) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->Initialize(deviceContext, deviceAccountStore, metaFilePath, dataFilePath, sender))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    NetworkInstallTaskInfo NetworkInstallTaskHolder::GetInfo() NN_NOEXCEPT
    {
        NetworkInstallTaskInfo info = { m_Task->GetProgress(), m_Task->GetApplicationId(), m_Task->GetAttribute(), m_IsRunning };
        auto throughput = m_Task->GetThroughput();
        info.downloaded = throughput.installed;
        info.elapsedTime = throughput.elapsedTime;
        return info;
    }

    Result NetworkInstallTaskHolder::SetAttribute(Bit64 attribute) NN_NOEXCEPT
    {
        return m_Task->SetAttribute(attribute);
    }

    Result ApplyDeltaTaskHolder::Initialize(const util::Uuid& uuid, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->Initialize(metaFilePath, dataFilePath))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    ApplyDeltaTaskInfo ApplyDeltaTaskHolder::GetInfo() NN_NOEXCEPT
    {
        ApplyDeltaTaskInfo info = { m_Task->GetProgress(), m_Task->GetApplicationId(), m_Task->GetThroughput() };
        return info;
    }

    Result LocalCommunicationReceiveApplicationTaskHolder::Initialize(const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->Initialize(ipv4, port, metaFilePath, dataFilePath))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    Result LocalCommunicationReceiveApplicationTaskHolder::InitializeForCleanup(const util::Uuid& uuid, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->InitializeForCleanup(metaFilePath, dataFilePath))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    LocalCommunicationReceiveApplicationTaskInfo LocalCommunicationReceiveApplicationTaskHolder::GetInfo() NN_NOEXCEPT
    {
        LocalCommunicationReceiveApplicationTaskInfo info = { m_Task->GetProgress(), m_Task->GetApplicationId(), m_IsRunning };
        auto throughput = m_Task->GetThroughput();
        info.downloaded = throughput.installed;
        info.elapsedTime = throughput.elapsedTime;
        return info;
    }

    Result LocalCommunicationSendApplicationTaskHolder::Initialize(const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const ncm::StorageContentMetaKey keyList[], int listCount, ncm::ApplicationId id) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->Initialize(ipv4, port, keyList, listCount, id))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    LocalCommunicationSendApplicationTaskInfo LocalCommunicationSendApplicationTaskHolder::GetInfo() NN_NOEXCEPT
    {
        LocalCommunicationSendApplicationTaskInfo info = { m_Task->GetProgress(), m_IsRunning };
        return info;
    }

    Result LocalCommunicationReceiveSystemUpdateTaskHolder::Initialize(const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->Initialize(ipv4, port, key, config, dataFilePath))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    Result LocalCommunicationReceiveSystemUpdateTaskHolder::InitializeForCleanup(const util::Uuid& uuid, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->InitializeForCleanup(key, config, dataFilePath))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    LocalCommunicationReceiveSystemUpdateTaskInfo LocalCommunicationReceiveSystemUpdateTaskHolder::GetInfo() NN_NOEXCEPT
    {
        LocalCommunicationReceiveSystemUpdateTaskInfo info = { m_Task->GetProgress(), m_Task->GetKey() };

        auto throughput = m_Task->GetThroughput();
        info.downloaded = throughput.installed;
        info.elapsedTime = throughput.elapsedTime;
        return info;
    }

    Result LocalCommunicationSendSystemUpdateTaskHolder::Initialize(const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key) NN_NOEXCEPT
    {
        m_Task.emplace();
        NN_RESULT_TRY(m_Task->Initialize(ipv4, port, key))
            NN_RESULT_CATCH_ALL
            {
                m_Task = util::nullopt;
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        m_Id.uuid = uuid;

        NN_RESULT_SUCCESS;
    }

    LocalCommunicationSendSystemUpdateTaskInfo LocalCommunicationSendSystemUpdateTaskHolder::GetInfo() NN_NOEXCEPT
    {
        LocalCommunicationSendSystemUpdateTaskInfo info = { m_Task->GetProgress(), m_IsRunning };
        return info;
    }

}}}
