﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/crypto/crypto_Sha256Generator.h>
#include <nn/ncm/ncm_ContentIdUtil.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace nim { namespace srv {

Result CalculateDeliveryContentSize(int64_t* outValue, const ncm::StorageContentMetaKey keyList[], int listCount) NN_NOEXCEPT
{
    int64_t totalSize = static_cast<int64_t>(listCount * sizeof(ncm::PackagedContentInfo));

    // 実際に送るコンテンツの分
    for (int i = 0; i < listCount; i++)
    {
        ncm::ContentMetaDatabase db;
        NN_RESULT_DO(ncm::OpenContentMetaDatabase(&db, keyList[i].storageId));
        ncm::ContentStorage storage;
        NN_RESULT_DO(ncm::OpenContentStorage(&storage, keyList[i].storageId));

        // 最初に落とす Meta の分
        {
            ncm::ContentId contentId;
            NN_RESULT_DO(db.GetContentIdByType(&contentId, keyList[i].key, ncm::ContentType::Meta));
            int64_t contentLength;
            NN_RESULT_DO(storage.GetSize(&contentLength, contentId));
            totalSize += contentLength;
        }

        int offset = 0;
        while (NN_STATIC_CONDITION(true))
        {
            const int ListCount = 16;
            ncm::ContentInfo infoList[ListCount];
            int count;
            NN_RESULT_DO(db.ListContentInfo(&count, infoList, ListCount, keyList[i].key, offset));
            for (int j = 0; j < count; j++)
            {
                // チケット分は省略
                 // 実際のストレージの消費量を計算
                 int64_t contentLength;
                 NN_RESULT_DO(storage.GetSize(&contentLength, infoList[j].GetId()));
                 totalSize += contentLength;
            }
            if (count != ListCount)
            {
                break;
            }
            offset += count;
        }
    }

    *outValue = totalSize;

    NN_RESULT_SUCCESS;
}
}}}
