﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <mutex>
#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentIdUtil.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/detail/nim_Log.h>
#include <nn/nim/srv/nim_LocalCommunicationSendApplicationTask.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_TypedStorage.h>

#include "nim_LocalCommunicationSendUtil.h"

namespace nn { namespace nim { namespace srv {

namespace {
}

    Result LocalCommunicationSendApplicationTask::Initialize(uint32_t ipv4, uint16_t port, const ncm::StorageContentMetaKey keyList[], int listCount, ncm::ApplicationId id) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(listCount <= LocalCommunicationMaxContentMetaCount, ResultOutOfMaxKeyList());

        NN_RESULT_DO(LocalCommunicationSendContentTaskBase::Initialize(ipv4, port));
        std::memcpy(m_KeyList, keyList, sizeof(keyList[0]) * listCount);
        m_KeyCount = listCount;
        m_AppId = id;

        NN_RESULT_SUCCESS;
    }

    Result LocalCommunicationSendApplicationTask::GetPackagedContentInfo(ncm::PackagedContentInfo* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT
    {
        for (int i = 0; i < m_KeyCount; i++)
        {
            if (m_KeyList[i].key == key)
            {
                NN_RESULT_DO(GetPackagedContentInfoImpl(outValue, m_KeyList[i].key, m_KeyList[i].storageId));
                NN_RESULT_SUCCESS;
            }
        }
        NN_RESULT_THROW(nim::ResultContentNotFound());
    }

    Result LocalCommunicationSendApplicationTask::GetStorage(ncm::StorageId* outValue, const ncm::ContentId& contentId) NN_NOEXCEPT
    {
        // オープンした結果をキャッシュする
        ncm::ContentMetaDatabase db;
        ncm::StorageId storageId = ncm::StorageId::None;

        for (int i = 0; i < m_KeyCount; i++)
        {
            if (storageId != m_KeyList[i].storageId)
            {
                NN_RESULT_DO(ncm::OpenContentMetaDatabase(&db, m_KeyList[i].storageId));
                storageId = m_KeyList[i].storageId;
            }

            bool hasContent;
            NN_RESULT_DO(db.HasContent(&hasContent, m_KeyList[i].key, contentId));

            if (hasContent)
            {
                *outValue = storageId;
                NN_RESULT_SUCCESS;
            }
        }

        NN_RESULT_THROW(nim::ResultContentNotFound());
    }
}}}
