﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/ec/system/ec_DeviceAuthenticationTypes.h>
#include <nn/util/util_Execution.h>

namespace nn { namespace nim { namespace srv {

    Result GetShopDeviceAuthenticationToken(ec::system::DeviceAuthenticationToken* outToken, util::Cancelable* pCancelable) NN_NOEXCEPT;
    Result GetShopDeviceAuthenticationToken(TimeSpan* outExpiration, ec::system::DeviceAuthenticationToken* outToken, util::Cancelable* pCancelable) NN_NOEXCEPT;

    Result ParseEciErrorResponseDestructively(int* outValue, char* response) NN_NOEXCEPT;

    Result ToEShopResultResponseDestructively(char* response) NN_NOEXCEPT;
}}}

