﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nim/nim_Result.h>
#include <nn/nim/srv/nim_DeviceAccountStore.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace nim { namespace srv {
    Result DeviceAccountStore::Save(const DeviceAccountInfo& info) NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_DataMutex);

        GetRef() = info;

        NN_RESULT_DO(SimpleDataStore::Save());
        NN_RESULT_SUCCESS;
    }

    Result DeviceAccountStore::Clear() NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_DataMutex);

        GetRef() = DeviceAccountInfo();

        NN_RESULT_DO(SimpleDataStore::Save());
        NN_RESULT_SUCCESS;
    }

    Result DeviceAccountStore::Get(DeviceAccountInfo* outValue) NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_DataMutex);

        auto info = SimpleDataStore::Get();

        NN_RESULT_THROW_UNLESS(
            util::Strnlen(info.id.data, static_cast<int>(sizeof(info.id.data))) != 0,
            ResultDeviceAccountNotRegistered());

        *outValue = info;
        NN_RESULT_SUCCESS;
    }

}}}
