﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/srv/nim_NetworkInstallUrl.h>
#include <nn/nim/srv/nim_ThreadAllocator.h>
#include <nn/nim/detail/nim_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include "nim_AsyncTemporaryFileBase.h"
#include "nim_AsyncVersionListImpl.h"

namespace nn { namespace nim { namespace srv {

    namespace
    {
        static const int VersionListThreadCount = 1;
        static const size_t StackSize = 16 * 1024;

        os::ThreadType g_VersionListThreadList[VersionListThreadCount];
        NN_OS_ALIGNAS_THREAD_STACK char g_VersionListStack[StackSize * VersionListThreadCount];

        ThreadAllocator g_VersionListThreadAllocator(g_VersionListThreadList, VersionListThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, VersionListTask), g_VersionListStack, sizeof(g_VersionListStack), StackSize, NN_SYSTEM_THREAD_NAME(nim, VersionListTask));
    }

    AsyncVersionListImpl::AsyncVersionListImpl() NN_NOEXCEPT : AsyncTemporaryFileBase(&g_VersionListThreadAllocator){}

    Result AsyncVersionListImpl::Initialize(DeviceContext* deviceContext, const char* path, const ETag& eTag) NN_NOEXCEPT
    {
        Url url;
        MakeVersionListUrl(&url);
        return AsyncTemporaryFileBase::Initialize(deviceContext, url, path, eTag);
    }

    Result AsyncVersionListImpl::Get() NN_NOEXCEPT
    {
        NN_RESULT_TRY(AsyncTemporaryFileBase::Get())
            NN_RESULT_CATCH(ResultHttpStatus403Forbidden)
            {
                NN_RESULT_THROW(ResultVersionListNotFound());
            }
            NN_RESULT_CATCH(ResultHttpStatus404NotFound)
            {
                NN_RESULT_THROW(ResultVersionListNotFound());
            }
            NN_RESULT_CATCH(ResultHttpStatus304NotModified)
            {
                NN_RESULT_THROW(ResultVersionListIsLatest());
            }
        NN_RESULT_END_TRY

        NN_RESULT_SUCCESS;
    }
}}}
