﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include "nim_AsyncTaskBufferAllocator.h"


namespace nn { namespace nim { namespace srv {
    namespace
    {
        static const size_t NetworkSystemUpdateTaskWorkingBufferSize = 256 * 1024;
        static const size_t NetworkInstallTaskWorkingBufferSize = 256 * 1024;
        static const size_t ApplyDeltaTaskWorkingBufferSize = 256 * 1024;
        static const size_t NetworkTaskWorkingBufferSize = NetworkSystemUpdateTaskWorkingBufferSize + NetworkInstallTaskWorkingBufferSize + ApplyDeltaTaskWorkingBufferSize;

        static const size_t LocalCommunicationTaskWorkingBufferSize = 256 * 1024;
        static const size_t SendSystemUpdateTaskWorkingBufferSize = LocalCommunicationTaskWorkingBufferSize;
        static const size_t ReceiveSystemUpdateTaskWorkingBufferSize = LocalCommunicationTaskWorkingBufferSize;
        static const size_t SendApplicationTaskWorkingBufferSize = LocalCommunicationTaskWorkingBufferSize;
        static const size_t ReceiveApplicationTaskWorkingBufferSize = LocalCommunicationTaskWorkingBufferSize;
        NN_STATIC_ASSERT(NetworkTaskWorkingBufferSize >= LocalCommunicationTaskWorkingBufferSize);

        static const size_t SyncTicketTaskWorkingBufferSize = 512000; // TORIAEZU: 8000 * 64

        // バッファの共有関係
        const detail::BufferFlagSet NetworkTaskBufferGroup = NetworkSystemUpdateTaskBufferFlag::Mask
                                                           | NetworkInstallTaskBufferFlag::Mask
                                                           | ApplyDeltaTaskBufferFlag::Mask
                                                           // TORIAEZU: ns との調整が付き次第、排他関係にする
                                                           | SyncTicketTaskBufferFlag::Mask;

        // 各タスクごとのバッファ設定
        detail::BufferInfo g_NetworkSystemUpdateTaskBufferInfo(NetworkSystemUpdateTaskWorkingBufferSize, NetworkSystemUpdateTaskBufferFlag::Mask, NetworkTaskBufferGroup);
        detail::BufferInfo g_NetworkInstallTaskBufferInfo(NetworkInstallTaskWorkingBufferSize, NetworkInstallTaskBufferFlag::Mask, NetworkTaskBufferGroup);
        detail::BufferInfo g_ApplyDeltaTaskBufferInfo(ApplyDeltaTaskWorkingBufferSize, ApplyDeltaTaskBufferFlag::Mask, NetworkTaskBufferGroup);
        detail::BufferInfo g_SendSystemUpdateTaskBufferInfo(SendSystemUpdateTaskWorkingBufferSize, LocalCommunicationSendSystemUpdateTaskBufferFlag::Mask, LocalCommunicationSendSystemUpdateTaskBufferFlag::Mask);
        detail::BufferInfo g_ReceiveSystemUpdateTaskBufferInfo(ReceiveSystemUpdateTaskWorkingBufferSize, LocalCommunicationReceiveSystemUpdateTaskBufferFlag::Mask, LocalCommunicationReceiveSystemUpdateTaskBufferFlag::Mask);
        detail::BufferInfo g_SendApplicationTaskBufferInfo(SendApplicationTaskWorkingBufferSize, LocalCommunicationSendApplicationTaskBufferFlag::Mask, LocalCommunicationSendApplicationTaskBufferFlag::Mask);
        detail::BufferInfo g_ReceiveApplicationTaskBufferInfo(ReceiveApplicationTaskWorkingBufferSize, LocalCommunicationReceiveApplicationTaskBufferFlag::Mask, LocalCommunicationReceiveApplicationTaskBufferFlag::Mask);
        detail::BufferInfo g_SyncTicketTaskBufferInfo(SyncTicketTaskWorkingBufferSize, SyncTicketTaskBufferFlag::Mask, NetworkTaskBufferGroup);

        // ワーキングバッファ全体
        const detail::BufferInfo* BufferInfoList[] =
        {
            &g_NetworkSystemUpdateTaskBufferInfo,
            &g_NetworkInstallTaskBufferInfo,
            &g_ApplyDeltaTaskBufferInfo,
            &g_SendSystemUpdateTaskBufferInfo,
            &g_ReceiveSystemUpdateTaskBufferInfo,
            &g_SendApplicationTaskBufferInfo,
            &g_ReceiveApplicationTaskBufferInfo,
            &g_SyncTicketTaskBufferInfo,
        };
        // TORIAEZU: ns との調整が付き次第、 SyncTicketTask の分を排他関係にしたうえでサイズを調整する
        static const size_t WorkingBufferSize = NetworkTaskWorkingBufferSize + SyncTicketTaskWorkingBufferSize + detail::MemoryManagementAreaSize;
        NN_ALIGNAS(detail::BufferAlign) Bit8 g_WorkingBuffer[WorkingBufferSize];
        detail::BufferAllocator g_BufferAllocator(g_WorkingBuffer, WorkingBufferSize, BufferInfoList, static_cast<int>(NN_ARRAY_SIZE(BufferInfoList)));
    }

    detail::BufferAllocator* GetAsyncTaskBufferAllocator() NN_NOEXCEPT
    {
        return &g_BufferAllocator;
    }

}}} // namespace nn::nim::srv
