﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ec/system/ec_DeviceAccountTypes.h>
#include <nn/ec/system/ec_TicketSystemApi.h>
#include <nn/es/es_Types.h>
#include <nn/nim/srv/nim_DeviceAccountStore.h>
#include <nn/nim/srv/nim_EciAccessor.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/result/result_HandlingUtility.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {

    template<typename TaskT>
    class AsyncTicketResultImplBase : public AsyncResultImpl<TaskT>
    {
    public:
        Result Initialize(DeviceContext* deviceContext) NN_NOEXCEPT
        {
            m_DeviceContext = deviceContext;
            return m_Connection.Initialize(deviceContext);
        }
        Result Cancel() NN_NOEXCEPT
        {
            m_Connection.Cancel();
            NN_RESULT_SUCCESS;
        }
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    protected:
        explicit AsyncTicketResultImplBase(TaskT* self) NN_NOEXCEPT;
        DeviceContext* m_DeviceContext;
        HttpConnection m_Connection;
    };

    template<typename TaskT, typename T>
    class AsyncTicketValueImplBase : public AsyncValueImpl<TaskT, T>
    {
    public:
        Result Initialize(DeviceContext* deviceContext) NN_NOEXCEPT
        {
            m_DeviceContext = deviceContext;
            return m_Connection.Initialize(deviceContext);
        }
        Result Cancel() NN_NOEXCEPT
        {
            m_Connection.Cancel();
            NN_RESULT_SUCCESS;
        }
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    protected:
        explicit AsyncTicketValueImplBase(TaskT* self) NN_NOEXCEPT;
        DeviceContext* m_DeviceContext;
        HttpConnection m_Connection;
    };

    class AsyncDownloadTicketImpl : public AsyncTicketResultImplBase<AsyncDownloadTicketImpl>
    {
    public:
        explicit AsyncDownloadTicketImpl(DeviceAccountStore* store) NN_NOEXCEPT;
        ~AsyncDownloadTicketImpl() NN_NOEXCEPT
        {
            Join();
        };

        Result Initialize(DeviceContext* deviceContext, const es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_RESULT_DO(AsyncTicketResultImplBase::Initialize(deviceContext));
            m_RightsId = rightsId;

            NN_RESULT_SUCCESS;
        }

        Result Execute() NN_NOEXCEPT;

    private:
        DeviceAccountStore* m_Store;
        es::RightsIdIncludingKeyId m_RightsId;
    };

    class AsyncDownloadTicketForPrepurchasedContentsImpl : public AsyncTicketValueImplBase<AsyncDownloadTicketForPrepurchasedContentsImpl, ec::system::TicketDownloadStatusForPrepurchasedContents>
    {
    public:
        explicit AsyncDownloadTicketForPrepurchasedContentsImpl(DeviceAccountStore* store) NN_NOEXCEPT;
        ~AsyncDownloadTicketForPrepurchasedContentsImpl() NN_NOEXCEPT
        {
            Join();
        };

        Result Initialize(DeviceContext* deviceContext, const es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
        {
            NN_RESULT_DO(AsyncTicketValueImplBase::Initialize(deviceContext));
            m_RightsId = rightsId;

            NN_RESULT_SUCCESS;
        }

        Result CancelImpl() NN_NOEXCEPT
        {
            return AsyncTicketValueImplBase::Cancel();
        }

        Result ExecuteAndValue(ec::system::TicketDownloadStatusForPrepurchasedContents* outValue) NN_NOEXCEPT;

    private:
        DeviceAccountStore* m_Store;
        es::RightsIdIncludingKeyId m_RightsId;
    };
}}}
