﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/detail/nim_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_StringUtil.h>
#include "nim_AsyncDownloadTicketImpl.h"
#include "nim_EcSystemThreadAllocator.h"
#include "nim_NetworkInstallUtil.h"

namespace nn { namespace nim { namespace srv {

    template<typename TaskT>
    AsyncTicketResultImplBase<TaskT>::AsyncTicketResultImplBase(TaskT* self) NN_NOEXCEPT :
        AsyncResultImpl<TaskT>(self, &GetEcSystemThreadAllocator()) {}

    template<typename TaskT, typename T>
    AsyncTicketValueImplBase<TaskT, T>::AsyncTicketValueImplBase(TaskT* self) NN_NOEXCEPT :
        AsyncValueImpl<TaskT, T>(self, &GetEcSystemThreadAllocator()) {}

    AsyncDownloadTicketImpl::AsyncDownloadTicketImpl(DeviceAccountStore* store) NN_NOEXCEPT : AsyncTicketResultImplBase(this), m_Store(store) {}
    Result AsyncDownloadTicketImpl::Execute() NN_NOEXCEPT
    {
        // チケットのダウンロード
        NN_RESULT_TRY(GetAndInstallCommonTicket(&m_Connection, m_RightsId))
            NN_RESULT_CATCH(ResultCommonTicketNotFound)
            {
                DeviceAccountInfo deviceAccountInfo;
                NN_RESULT_TRY(m_Store->Get(&deviceAccountInfo))
                    NN_RESULT_CATCH_CONVERT(ResultDeviceAccountNotRegistered, ResultDeviceAccountNotRegisteredForDownloadTicket())
                NN_RESULT_END_TRY

                EciAccessor accessor(m_DeviceContext, &m_Connection);

                NN_RESULT_TRY(accessor.DownloadTicket(deviceAccountInfo.id, deviceAccountInfo.token, m_RightsId))
                    NN_RESULT_CATCH_CONVERT(ResultPersonalizedTicketNotFound, ResultTicketNotFound())
                NN_RESULT_END_TRY
            }
        NN_RESULT_END_TRY

        NN_RESULT_SUCCESS;
    }

    AsyncDownloadTicketForPrepurchasedContentsImpl::AsyncDownloadTicketForPrepurchasedContentsImpl(DeviceAccountStore* store) NN_NOEXCEPT : AsyncTicketValueImplBase(this), m_Store(store) {}
    Result AsyncDownloadTicketForPrepurchasedContentsImpl::ExecuteAndValue(ec::system::TicketDownloadStatusForPrepurchasedContents* outValue) NN_NOEXCEPT
    {
        // チケットのダウンロード
        DeviceAccountInfo deviceAccountInfo;
        NN_RESULT_TRY(m_Store->Get(&deviceAccountInfo))
            NN_RESULT_CATCH_CONVERT(ResultDeviceAccountNotRegistered, ResultDeviceAccountNotRegisteredForDownloadTicket())
        NN_RESULT_END_TRY

        EciAccessor accessor(m_DeviceContext, &m_Connection);

        NN_RESULT_TRY(accessor.DownloadTicketForPrepurchasedContents(outValue, deviceAccountInfo.id, deviceAccountInfo.token, m_RightsId))
            NN_RESULT_CATCH_CONVERT(ResultPersonalizedTicketNotFound, ResultTicketNotFound())
        NN_RESULT_END_TRY

        NN_RESULT_SUCCESS;
    }
}}}
