﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/ec/ec_Result.h>
#include <nn/ec/system/ec_DeviceAccountApi.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/srv/nim_NetworkInstallUrl.h>
#include <nn/nim/srv/nim_ThreadAllocator.h>
#include <nn/nim/detail/nim_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include "nim_AsyncDownloadTaskListImpl.h"

namespace nn { namespace nim { namespace srv {

    namespace
    {
        static const int DownloadTaskListThreadCount = 1;
        static const size_t StackSize = 16 * 1024;

        os::ThreadType g_DownloadTaskListThreadList[DownloadTaskListThreadCount];
        NN_OS_ALIGNAS_THREAD_STACK char g_DownloadTaskListStack[StackSize * DownloadTaskListThreadCount];

        ThreadAllocator g_DownloadTaskListThreadAllocator(g_DownloadTaskListThreadList, DownloadTaskListThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, DownloadTaskListTask), g_DownloadTaskListStack, sizeof(g_DownloadTaskListStack), StackSize, NN_SYSTEM_THREAD_NAME(nim, DownloadTaskListTask));
    }

    AsyncDownloadTaskListImpl::AsyncDownloadTaskListImpl() NN_NOEXCEPT : AsyncTemporaryFileBase(&g_DownloadTaskListThreadAllocator) {}

    Result AsyncDownloadTaskListImpl::Initialize(DeviceContext* deviceContext, const char* path, const ETag& eTag) NN_NOEXCEPT
    {
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
        {
            // デバイスアカウントが無いと DTL 受信に失敗する仕様
            ec::system::DeviceAccountInfo info;
            NN_RESULT_TRY(ec::system::GetDeviceAccountInfo(&info))
                NN_RESULT_CATCH_CONVERT(ec::ResultDeviceAccountNotRegistered, ResultDeviceAccountNotRegistered())
            NN_RESULT_END_TRY
        }
#endif

        Url url;
        MakeDownloadTaskListUrl(&url, deviceContext->GetDeviceId());
        return AsyncTemporaryFileBase::Initialize(deviceContext, url, path, eTag);
    }

    Result AsyncDownloadTaskListImpl::Get() NN_NOEXCEPT
    {
        NN_RESULT_TRY(AsyncTemporaryFileBase::Get())
            NN_RESULT_CATCH(ResultHttpStatus403Forbidden)
            {
                NN_RESULT_THROW(ResultDownloadTaskListNotFound());
            }
            NN_RESULT_CATCH(ResultHttpStatus404NotFound)
            {
                NN_RESULT_THROW(ResultDownloadTaskListNotFound());
            }
            NN_RESULT_CATCH(ResultHttpStatus304NotModified)
            {
                NN_RESULT_THROW(ResultDownloadTaskListIsLatest());
            }
        NN_RESULT_END_TRY

        NN_RESULT_SUCCESS;
    }
}}}
