﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/ec/system/ec_DeviceLinkTypes.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/nim/srv/nim_VirtualAccountStore.h>
#include <nn/util/util_Execution.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {
    class AsyncUnlinkDeviceImpl : public AsyncResultImpl<AsyncUnlinkDeviceImpl>
    {
    public:
        AsyncUnlinkDeviceImpl() NN_NOEXCEPT;
        ~AsyncUnlinkDeviceImpl() NN_NOEXCEPT
        {
            AsyncResultImpl<AsyncUnlinkDeviceImpl>::Join();
        }

        Result Initialize(DeviceContext* deviceContext, VirtualAccountStore* vaStore, account::Uid uid) NN_NOEXCEPT;
        Result Initialize(DeviceContext* deviceContext, account::NintendoAccountId naUserId) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_HttpConnection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        account::Uid m_Uid;
        account::NintendoAccountId m_NaUserId;
        ec::system::VirtualAccountId m_VaId;
        HttpConnection m_HttpConnection;
        VirtualAccountStore* m_VaStore;
        util::Cancelable m_Cancelable;
    };

    class AsyncUnlinkDeviceAllImpl : public AsyncResultImpl<AsyncUnlinkDeviceAllImpl>
    {
    public:
        AsyncUnlinkDeviceAllImpl() NN_NOEXCEPT;
        ~AsyncUnlinkDeviceAllImpl() NN_NOEXCEPT
        {
            AsyncResultImpl<AsyncUnlinkDeviceAllImpl>::Join();
        }

        Result Initialize(DeviceContext* deviceContext, VirtualAccountStore* vaStore) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_HttpConnection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        HttpConnection m_HttpConnection;
        VirtualAccountStore* m_VaStore;
        Bit64 m_DeviceId;
        util::Cancelable m_Cancelable;
    };

    class AsyncLinkDeviceImpl : public AsyncResultImpl<AsyncLinkDeviceImpl>
    {
    public:
        AsyncLinkDeviceImpl() NN_NOEXCEPT;
        ~AsyncLinkDeviceImpl() NN_NOEXCEPT
        {
            AsyncResultImpl<AsyncLinkDeviceImpl>::Join();
        }

        Result Initialize(DeviceContext* deviceContext, VirtualAccountStore* vaStore, account::Uid uid) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_HttpConnection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        account::Uid m_Uid;
        account::NintendoAccountAuthorizationRequestContext m_AuthRequest;
        HttpConnection m_HttpConnection;
        VirtualAccountStore* m_VaStore;
        util::Cancelable m_Cancelable;
    };

    class AsyncCreateVirtualAccountImpl : public AsyncResultImpl<AsyncCreateVirtualAccountImpl>
    {
    public:
        AsyncCreateVirtualAccountImpl() NN_NOEXCEPT;
        ~AsyncCreateVirtualAccountImpl() NN_NOEXCEPT
        {
            AsyncResultImpl<AsyncCreateVirtualAccountImpl>::Join();
        }

        Result Initialize(DeviceContext* deviceContext, account::Uid uid) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_HttpConnection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        account::Uid m_Uid;
        account::CachedNintendoAccountInfoForSystemService m_AccountInfo;
        account::NintendoAccountAuthorizationRequestContext m_AuthRequest;
        HttpConnection m_HttpConnection;
    };

    class AsyncDeviceLinkStatusImpl : public AsyncValueImpl<AsyncDeviceLinkStatusImpl, ec::system::DeviceLinkStatus>
    {
    public:
        AsyncDeviceLinkStatusImpl() NN_NOEXCEPT;
        ~AsyncDeviceLinkStatusImpl() NN_NOEXCEPT
        {
            Join();
        }

        Result Initialize(DeviceContext* deviceContext, account::Uid uid) NN_NOEXCEPT;
        Result ExecuteAndValue(ec::system::DeviceLinkStatus* outValue) NN_NOEXCEPT;
        Result CancelImpl() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_HttpConnection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        account::Uid m_Uid;
        account::NintendoAccountAuthorizationRequestContext m_AuthRequest;
        HttpConnection m_HttpConnection;
    };
}}}
