﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/nim/srv/nim_ThreadAllocator.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/util/util_Optional.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {
    class AsyncApplicationControlImpl : public AsyncValueImpl<AsyncApplicationControlImpl, ApplicationControlInfo>
    {
    public:
        AsyncApplicationControlImpl() NN_NOEXCEPT;
        ~AsyncApplicationControlImpl() NN_NOEXCEPT;

        Result Initialize(DeviceContext* deviceContext, ncm::ApplicationId id, uint32_t version) NN_NOEXCEPT;
        Result InitializeLatest(DeviceContext* deviceContext, ncm::ApplicationId id) NN_NOEXCEPT;
        Result ExecuteAndValue(ApplicationControlInfo* outValue) NN_NOEXCEPT;
        Result CancelImpl() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        Result InitializeImpl(DeviceContext* deviceContext, ncm::ApplicationId id, uint32_t version, bool requiresLatest) NN_NOEXCEPT;
        ncm::ApplicationId m_ApplicationId;
        uint32_t m_Version;
        bool m_RequiresLatest;
        ncm::ContentStorage m_Storage;
        util::optional<ncm::PlaceHolderId> m_PlaceHolderId;
        util::optional<int64_t> m_ReceivedContentLength;
        util::optional<uint32_t> m_ReceivedVersion;
        util::optional<ncm::ContentId> m_ReceivedContentId;
        util::optional<ncm::Hash> m_ReceivedHash;
        HttpConnection m_Connection;

        int64_t m_Written;
        Result Write(const void* buffer, size_t bufferSize) NN_NOEXCEPT;
        Result Flush() NN_NOEXCEPT;
        Result WritePlaceHolder(const void* buffer, size_t bufferSize) NN_NOEXCEPT;
        char m_Buffer[128 * 1024];
        size_t m_BufferFilledSize;
    };
}}}
