﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.account
{
    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid { }
}

namespace nn.err
{
    [CppRefPath(@"<nn/err/err_Types.h>")]
    [ExternalStruct(8, 4)]
    public struct ErrorCode { }
}

namespace nn.nim.ShopServiceAccessTypes
{
    [CppRefPath(@"<nn/nim/nim_ShopServiceAccessTypes.h>")]
    [ExternalStruct(1, 1)]
    public struct Server { }

    [CppRefPath(@"<nn/nim/nim_ShopServiceAccessTypes.h>")]
    [ExternalStruct(32, 8)]
    public struct FixedParams { }
}

namespace nn.nim.detail
{
    public interface IShopServiceAsync : IServiceObject
    {
        [MethodId(0)]
        Result Cancel();

        [MethodId(1)]
        Result GetSize(Out<uint64_t> outValue);

        [MethodId(2)]
        Result Read(Out<uint64_t> outValue, uint64_t offset, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer outBuffer);

        [MethodId(3)]
        Result GetErrorCode(Out<nn.err.ErrorCode> outCode);

        [MethodId(4)]
        Result Request();

        [MethodId(5)]
        Result Prepare([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<char_t> inPath, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<char_t> inPost);

        // TODO: 追加の可変長パラメータ登録が必要な場合は IPCメソッド追加する事で拡張予定。
    }

    public interface IShopServiceAccessor : IServiceObject
    {
        [MethodId(0)]
        Result CreateAsyncInterface(Out<NativeHandle> outEventHandle, Out<IShopServiceAsync> outAsync, nn.nim.ShopServiceAccessTypes.FixedParams inFixedParams);
    }

    public interface IShopServiceAccessServer : IServiceObject
    {
        [MethodId(0)]
        Result CreateAccessorInterface(Out<IShopServiceAccessor> outValue, nn.nim.ShopServiceAccessTypes.Server inServer);
    }

    public interface IShopServiceAccessServerInterface : IServiceObject
    {
        [MethodId(0)]
        Result CreateServerInterface(Out<IShopServiceAccessServer> outValue, [ProcessId] Bit64 clientProcessId, NativeHandle inTransferHandle, uint64_t inTransferTotalSize);

        [MethodId(1)]
        Result RefreshDebugAvailability();

        [MethodId(2)]
        Result ClearDebugResponse();

        [MethodId(3)]
        Result RegisterDebugResponse(nn.nim.ShopServiceAccessTypes.Server inKeyTarget
            , [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<char_t> inKeyPath
            , [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<char_t> inValueResponse
            , uint32_t inExpectResult
            , uint32_t inHappenedRate
        );
    }

}
