﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.err
{
    [CppRefPath(@"<nn/err/err_ErrorContext.h>")]
    [ExternalStruct(512, 8)]
    [LargeData]
    public struct ErrorContext { }
}

namespace nn.nim
{
    [CppRefPath(@"<nn/nim/nim_ETag.h>")]
    [ExternalStruct(40, 8)]
    public struct ETag { }

    [CppRefPath(@"<nn/nim/nim_AsyncProgress.h>")]
    [ExternalStruct(16, 8)]
    public struct AsyncProgress { }
}

namespace nn.nim.detail
{
    public interface IAsyncResult : IServiceObject
    {
        [MethodId(0)]
        Result Get();

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result GetErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue);
    }

    public interface IAsyncProgressResult : IServiceObject
    {
        [MethodId(0)]
        Result Get();

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result GetProgress(Out<AsyncProgress> outValue);

        [MethodId(3)]
        Result GetErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue);
    }

    public interface IAsyncValue : IServiceObject
    {
        [MethodId(0)]
        Result GetSize(Out<uint64_t> outValue);

        [MethodId(1)]
        Result Get(OutBuffer buffer);

        [MethodId(2)]
        Result Cancel();

        [MethodId(3)]
        Result GetErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue);
    }

    public interface IAsyncData : IServiceObject
    {
        [MethodId(0)]
        Result Get();

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result GetSize(Out<int64_t> outValue);

        [MethodId(3)]
        Result Read(Out<uint64_t> outValue, int64_t offset, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer outBuffer);

        [MethodId(4)]
        Result GetETag(Out<nn.nim.ETag> outValue);

        [MethodId(5)]
        Result GetErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue);
    }
}


