﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_TypesRequirement.h>
#include <nn/nifm/nifm_ApiHandleNetworkRequestResult.h>

#include <mutex>


namespace nn
{
namespace nifm
{

namespace
{
    static const RequestParameters RequestParametersInternet = { RequirementPreset_InternetBestEffort };
}

NetworkConnection::NetworkConnection() NN_NOEXCEPT
    : m_Request(RequestParametersInternet)
{
}

NetworkConnection::NetworkConnection(nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
    : m_Request(RequestParametersInternet, eventClearMode)
{
}

NetworkConnection::~NetworkConnection() NN_NOEXCEPT
{
}

void NetworkConnection::SubmitRequest() NN_NOEXCEPT
{
    m_Request.Submit();
}

void NetworkConnection::SubmitRequestAndWait() NN_NOEXCEPT
{
    m_Request.SubmitAndWait();
}

void NetworkConnection::CancelRequest() NN_NOEXCEPT
{
    m_Request.Cancel();
}

bool NetworkConnection::IsRequestOnHold() NN_NOEXCEPT
{
    return m_Request.GetRequestState() == RequestState_OnHold;
}

bool NetworkConnection::IsAvailable() NN_NOEXCEPT
{
    return m_Request.GetRequestState() == RequestState_Accepted;
}

nn::os::SystemEvent& NetworkConnection::GetSystemEvent() NN_NOEXCEPT
{
    return m_Request.GetSystemEvent();
}

RequestState NetworkConnection::GetRequestState() NN_NOEXCEPT
{
    return m_Request.GetRequestState();
}

nn::Result NetworkConnection::GetResult() NN_NOEXCEPT
{
    NN_RESULT_THROW(m_Request.GetResult());
}

RequestHandle NetworkConnection::GetRequestHandle() NN_NOEXCEPT
{
    return m_Request.GetHandle();
}

nn::Result NetworkConnection::HandleNetworkRequestResult() NN_NOEXCEPT
{
    // 利用要求が成功していれば即座に返る
    NN_RESULT_THROW_UNLESS(GetResult().IsFailure(), ResultSuccess());

    nn::applet::LibraryAppletHandle libraryAppletHandle;

    NN_RESULT_DO(PrepareHandlingNetworkRequestResult(GetRequestHandle(), &libraryAppletHandle));
    NN_RESULT_DO(StartHandlingNetworkRequestResult(libraryAppletHandle, nullptr));
    NN_RESULT_DO(FinishHandlingNetworkRequestResult(libraryAppletHandle));

    NN_RESULT_THROW(ResultErrorHandlingCompleted());
}

}
}
