﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiNetworkConnection.h>
#include <nn/nifm/nifm_ApiRequest.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/nifm_NetworkConnection.h>

namespace nn
{
namespace nifm
{

namespace detail
{
    nn::Result GetNetworkConnectionPointer(NetworkConnection** ppNetworkConnection) NN_NOEXCEPT;
}


void SubmitNetworkRequest() NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;

    if (detail::GetNetworkConnectionPointer(&pNetworkConnection).IsFailure())
    {
        return;
    }

    pNetworkConnection->SubmitRequest();
}

void SubmitNetworkRequestAndWait() NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;

    if (detail::GetNetworkConnectionPointer(&pNetworkConnection).IsFailure())
    {
        return;
    }

    pNetworkConnection->SubmitRequestAndWait();
}

void CancelNetworkRequest() NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;

    if (detail::GetNetworkConnectionPointer(&pNetworkConnection).IsFailure())
    {
        return;
    }

    pNetworkConnection->CancelRequest();
}

bool IsNetworkRequestOnHold() NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;

    if (detail::GetNetworkConnectionPointer(&pNetworkConnection).IsFailure())
    {
        return false;
    }

    return pNetworkConnection->IsRequestOnHold();
}

bool IsNetworkAvailable() NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;

    if (detail::GetNetworkConnectionPointer(&pNetworkConnection).IsFailure())
    {
        return false;
    }

    return pNetworkConnection->IsAvailable();
}

nn::Result HandleNetworkRequestResult() NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;

    NN_RESULT_DO(detail::GetNetworkConnectionPointer(&pNetworkConnection));

    NN_RESULT_THROW(pNetworkConnection->HandleNetworkRequestResult());
}

void SetLocalNetworkMode(bool isLocalNetworkMode) NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;

    if (detail::GetNetworkConnectionPointer(&pNetworkConnection).IsFailure())
    {
        return;
    }

    SetRequestConnectionConfirmationOption(
        pNetworkConnection->GetRequestHandle(),
        isLocalNetworkMode ? ConnectionConfirmationOption_Prohibited : ConnectionConfirmationOption_Required
    );
}

// for test
NetworkConnection* GetGlobalNetworkConnectionPointer() NN_NOEXCEPT
{
    NetworkConnection* pNetworkConnection;
    if (detail::GetNetworkConnectionPointer(&pNetworkConnection).IsSuccess())
    {
        return pNetworkConnection;
    }

    return nullptr;
}

}
}

