﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiIpAddress.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/util/nifm_SfUtility.h>


namespace nn
{
namespace nifm
{

namespace detail
{
    nn::Result GetGeneralServicePointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT;
}

nn::Result GetCurrentPrimaryIpAddress( nn::socket::InAddr* pOutInAddr ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL( pOutInAddr );

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    IpV4Address ipV4Address;
    NN_RESULT_DO(pGeneralService->GetCurrentIpAddress(&ipV4Address));

    pOutInAddr->S_addr = (static_cast<uint32_t>(ipV4Address.data[0]) <<  0) |
                         (static_cast<uint32_t>(ipV4Address.data[1]) <<  8) |
                         (static_cast<uint32_t>(ipV4Address.data[2]) << 16) |
                         (static_cast<uint32_t>(ipV4Address.data[3]) << 24);

    NN_RESULT_SUCCESS;
}

nn::Result GetCurrentPrimaryIpAddress( in_addr* pOutInAddr ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL( pOutInAddr );

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    IpV4Address ipV4Address;
    NN_RESULT_DO(pGeneralService->GetCurrentIpAddress(&ipV4Address));

    pOutInAddr->s_addr = (static_cast<uint32_t>(ipV4Address.data[0]) <<  0) |
                         (static_cast<uint32_t>(ipV4Address.data[1]) <<  8) |
                         (static_cast<uint32_t>(ipV4Address.data[2]) << 16) |
                         (static_cast<uint32_t>(ipV4Address.data[3]) << 24);

    NN_RESULT_SUCCESS;
}

nn::Result GetCurrentIpConfigInfo( nn::socket::InAddr* pOutIpAddress, nn::socket::InAddr* pOutSubnetMask, nn::socket::InAddr* pOutDefaultGateway, nn::socket::InAddr* pOutPreferredDns, nn::socket::InAddr* pOutAlternateDns ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL( pOutIpAddress );
    NN_ABORT_UNLESS_NOT_NULL( pOutSubnetMask );
    NN_ABORT_UNLESS_NOT_NULL( pOutDefaultGateway );
    NN_ABORT_UNLESS_NOT_NULL( pOutPreferredDns );
    NN_ABORT_UNLESS_NOT_NULL( pOutAlternateDns );

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    IpAddressSetting ipAddressSetting;
    DnsSetting dnsSetting;
    NN_RESULT_DO(pGeneralService->GetCurrentIpConfigInfo( &ipAddressSetting, &dnsSetting ));

    pOutIpAddress->S_addr = (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[0]) <<  0) |
                            (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[1]) <<  8) |
                            (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[2]) << 16) |
                            (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[3]) << 24);
    pOutSubnetMask->S_addr = (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[0]) <<  0) |
                             (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[1]) <<  8) |
                             (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[2]) << 16) |
                             (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[3]) << 24);
    pOutDefaultGateway->S_addr = (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[0]) <<  0) |
                                 (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[1]) <<  8) |
                                 (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[2]) << 16) |
                                 (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[3]) << 24);
    pOutPreferredDns->S_addr = (static_cast<uint32_t>(dnsSetting.preferredDns.data[0]) <<  0) |
                               (static_cast<uint32_t>(dnsSetting.preferredDns.data[1]) <<  8) |
                               (static_cast<uint32_t>(dnsSetting.preferredDns.data[2]) << 16) |
                               (static_cast<uint32_t>(dnsSetting.preferredDns.data[3]) << 24);
    pOutAlternateDns->S_addr = (static_cast<uint32_t>(dnsSetting.alternateDns.data[0]) <<  0) |
                               (static_cast<uint32_t>(dnsSetting.alternateDns.data[1]) <<  8) |
                               (static_cast<uint32_t>(dnsSetting.alternateDns.data[2]) << 16) |
                               (static_cast<uint32_t>(dnsSetting.alternateDns.data[3]) << 24);

    NN_RESULT_SUCCESS;
}

nn::Result GetCurrentIpConfigInfo( in_addr* pOutIpAddress, in_addr* pOutSubnetMask, in_addr* pOutDefaultGateway, in_addr* pOutPreferredDns, in_addr* pOutAlternateDns ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL( pOutIpAddress );
    NN_ABORT_UNLESS_NOT_NULL( pOutSubnetMask );
    NN_ABORT_UNLESS_NOT_NULL( pOutDefaultGateway );
    NN_ABORT_UNLESS_NOT_NULL( pOutPreferredDns );
    NN_ABORT_UNLESS_NOT_NULL( pOutAlternateDns );

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    IpAddressSetting ipAddressSetting;
    DnsSetting dnsSetting;
    NN_RESULT_DO(pGeneralService->GetCurrentIpConfigInfo( &ipAddressSetting, &dnsSetting ));

    pOutIpAddress->s_addr = (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[0]) <<  0) |
                            (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[1]) <<  8) |
                            (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[2]) << 16) |
                            (static_cast<uint32_t>(ipAddressSetting.ipAddress.data[3]) << 24);
    pOutSubnetMask->s_addr = (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[0]) <<  0) |
                             (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[1]) <<  8) |
                             (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[2]) << 16) |
                             (static_cast<uint32_t>(ipAddressSetting.subnetMask.data[3]) << 24);
    pOutDefaultGateway->s_addr = (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[0]) <<  0) |
                                 (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[1]) <<  8) |
                                 (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[2]) << 16) |
                                 (static_cast<uint32_t>(ipAddressSetting.defaultGateway.data[3]) << 24);
    pOutPreferredDns->s_addr = (static_cast<uint32_t>(dnsSetting.preferredDns.data[0]) <<  0) |
                               (static_cast<uint32_t>(dnsSetting.preferredDns.data[1]) <<  8) |
                               (static_cast<uint32_t>(dnsSetting.preferredDns.data[2]) << 16) |
                               (static_cast<uint32_t>(dnsSetting.preferredDns.data[3]) << 24);
    pOutAlternateDns->s_addr = (static_cast<uint32_t>(dnsSetting.alternateDns.data[0]) <<  0) |
                               (static_cast<uint32_t>(dnsSetting.alternateDns.data[1]) <<  8) |
                               (static_cast<uint32_t>(dnsSetting.alternateDns.data[2]) << 16) |
                               (static_cast<uint32_t>(dnsSetting.alternateDns.data[3]) << 24);

    NN_RESULT_SUCCESS;
}

}
}

