﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiForTest.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/util/nifm_SfUtility.h>


namespace nn
{
namespace nifm
{

namespace detail
{
    nn::Result GetGeneralServicePointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT;
}

nn::Result PutToSleep() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    NN_RESULT_DO(pGeneralService->PutToSleep());

    NN_RESULT_SUCCESS;
}

nn::Result WakeUp() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    NN_RESULT_DO(pGeneralService->WakeUp());

    NN_RESULT_SUCCESS;
}

nn::Result Shutdown() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    NN_RESULT_DO(pGeneralService->Shutdown());

    NN_RESULT_SUCCESS;
}

nn::Result SetExclusiveClient(ClientId clientId) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    NN_RESULT_DO(pGeneralService->SetExclusiveClient(clientId));

    NN_RESULT_SUCCESS;
}

nn::Result GetDefaultIpSetting(IpSettingData* pOutIpSettingData) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    NN_RESULT_DO(pGeneralService->GetDefaultIpSetting(pOutIpSettingData));

    NN_RESULT_SUCCESS;
}

nn::Result SetDefaultIpSetting(const IpSettingData& ipSettingData) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;

    NN_RESULT_DO(detail::GetGeneralServicePointer(&pGeneralService));

    NN_RESULT_DO(pGeneralService->SetDefaultIpSetting(ipSettingData));

    NN_RESULT_SUCCESS;
}

}
}

