﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/util/nifm_SettingsUtility.h>

#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>


namespace nn
{
namespace nifm
{
namespace detail
{

nn::Result IsCommunicationControlEnabledForTest(bool* pOutIsCommunicationControlEnabledForTest) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutIsCommunicationControlEnabledForTest);

    bool isCommunicationControlEnabledForTest = false;

    size_t outSize = nn::settings::fwdbg::GetSettingsItemValue(
        &isCommunicationControlEnabledForTest,
        sizeof(isCommunicationControlEnabledForTest),
        "nifm",
        "is_communication_control_enabled_for_test"
    );

    NN_RESULT_THROW_UNLESS(outSize == sizeof(isCommunicationControlEnabledForTest), ResultNotImplemented());

    *pOutIsCommunicationControlEnabledForTest = isCommunicationControlEnabledForTest;

    NN_RESULT_SUCCESS;
}

}
}
}
