﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/util/nifm_FwdbgSettings.h>

#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/util/util_LockGuard.h>

#include <mutex>

namespace nn
{
namespace nifm
{
namespace detail
{

namespace
{
    FwdbgSettings g_FwdbgSettings;
}

FwdbgSettings::FwdbgSettings() NN_NOEXCEPT
    : m_IsInitialized(false),
      m_ConnectionTestTimeout(45000),
      m_ApplyConfigTimeout(30000),
      m_EthernetAdapterStandbyTime(10000)
{
}

FwdbgSettings::~FwdbgSettings() NN_NOEXCEPT
{
}

void FwdbgSettings::Initialize() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);

    if (m_IsInitialized)
    {
        return;
    }

    const char* name = "nifm";
    int32_t outValue;

    if (nn::settings::fwdbg::GetSettingsItemValue(
        &outValue, sizeof(outValue), name, "connection_test_timeout"
        ) == sizeof(outValue))
    {
        m_ConnectionTestTimeout = outValue;
    }

    if (nn::settings::fwdbg::GetSettingsItemValue(
        &outValue, sizeof(outValue), name, "apply_config_timeout"
        ) == sizeof(outValue))
    {
        m_ApplyConfigTimeout = outValue;
    }

    if (nn::settings::fwdbg::GetSettingsItemValue(
        &outValue, sizeof(outValue), name, "ethernet_adapter_standby_time"
        ) == sizeof(outValue))
    {
        m_EthernetAdapterStandbyTime = outValue;
    }

    m_IsInitialized = true;
}

TimeSpan FwdbgSettings::GetConnectionTestTimeout() const NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);
    NN_SDK_ASSERT(m_IsInitialized);
    return TimeSpan::FromMilliSeconds(m_ConnectionTestTimeout);
}

TimeSpan FwdbgSettings::GetApplyConfigTimeout() const NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);
    NN_SDK_ASSERT(m_IsInitialized);
    return TimeSpan::FromMilliSeconds(m_ApplyConfigTimeout);
}

TimeSpan FwdbgSettings::GetEthernetAdapterStandbyTime() const NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);
    NN_SDK_ASSERT(m_IsInitialized);
    return TimeSpan::FromMilliSeconds(m_EthernetAdapterStandbyTime);
}

FwdbgSettings& FwdbgSettings::GetSingleton() NN_NOEXCEPT
{
    g_FwdbgSettings.Initialize();
    return g_FwdbgSettings;
}

}
}
}

