﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/service/nifm_ServiceProviderClient.h>
#include <nn/nifm/detail/service/nifm_ServiceNames.h>

#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
#include <nn/sf/sf_ShimLibraryUtility.h>
#if NN_DETAIL_NIFM_CONFIG_SERVER_MODEL == NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_THREAD
#include <nn/nn_SystemThreadDefinition.h>
#endif
#endif

namespace nn
{
namespace nifm
{
namespace detail
{

#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
namespace {
    // サブドメインで16個までのサービスオブジェクトを許容
    nn::sf::SimpleAllInOneHipcSubDomainClientManager<16> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_SUB_DOMAIN_CLIENT_MANAGER_INITIALIZER;
    nn::sf::ShimLibraryObjectHolder<detail::IStaticService> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
}
#endif

ServiceProviderClient::ServiceProviderClient() NN_NOEXCEPT
{
#if NN_DETAIL_NIFM_CONFIG_SERVER_MODEL == NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_THREAD
#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
    NN_DETAIL_NIFM_TRACE_V3("NIFM service ready.\n");
#elif NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    void* pThreadStack = reinterpret_cast<void*>(nn::util::align_up(reinterpret_cast<uintptr_t>(m_ThreadStackBuffer), nn::os::ThreadStackAlignment));

    Result result = nn::os::CreateThread(&m_ThreadType, ServerManagerThreadFunction, this, pThreadStack, ThreadStackSize, NN_SYSTEM_THREAD_PRIORITY(nifm, IpcServer));
    nn::os::SetThreadNamePointer(&m_ThreadType, NN_SYSTEM_THREAD_NAME(nifm, IpcServer));
    if(result.IsSuccess())
    {
        nn::os::StartThread(&m_ThreadType);
    }
#endif
#endif
}

ServiceProviderClient::~ServiceProviderClient() NN_NOEXCEPT
{
}

#if NN_DETAIL_NIFM_CONFIG_SERVER_MODEL == NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_THREAD
#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
void ServiceProviderClient::ServerManagerThreadFunction(void* pContext) NN_NOEXCEPT
{
    reinterpret_cast<ServiceProviderClient*>(pContext)->m_ServiceProvider.Start();
}
#endif
#endif

nn::Result ServiceProviderClient::GetUserServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* pGeneralService) NN_NOEXCEPT
{
#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
    m_ServiceProvider.m_HipcServerManager.GetUserServiceSharedPointer(pGeneralService);
    NN_RESULT_SUCCESS;
#elif NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, detail::UserServiceName));
    NN_RESULT_THROW(g_Holder.GetObject()->CreateGeneralService(pGeneralService, 0));
#endif
}

nn::Result ServiceProviderClient::GetAdminServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* pGeneralService) NN_NOEXCEPT
{
#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
    m_ServiceProvider.m_HipcServerManager.GetAdminServiceSharedPointer(pGeneralService);
    NN_RESULT_SUCCESS;
#elif NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, detail::AdminServiceName));
    NN_RESULT_THROW(g_Holder.GetObject()->CreateGeneralService(pGeneralService, 0));
#endif
}

nn::Result ServiceProviderClient::GetSystemServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* pGeneralService) NN_NOEXCEPT
{
#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
    m_ServiceProvider.m_HipcServerManager.GetAdminServiceSharedPointer(pGeneralService);
    NN_RESULT_SUCCESS;
#elif NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, detail::SystemServiceName));
    NN_RESULT_THROW(g_Holder.GetObject()->CreateGeneralService(pGeneralService, 0));
#endif
}

void ServiceProviderClient::Finalize() NN_NOEXCEPT
{
#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    g_Holder.FinalizeHolder();
#endif
}

}
}
}
