﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/service/nifm_ServiceNames.h>
#include <nn/nifm/detail/service/nifm_HipcServerManager.h>

#include <nn/nifm/detail/service/nifm_Capability.h>

#include <nn/nifm/detail/service/nifm_ServiceProvider.h>
#include <nn/nifm/detail/core/nifm_PowerStateCoordinator.h>


namespace nn
{
namespace nifm
{
namespace detail
{

#if defined(NN_BUILD_CONFIG_OS_WIN)
    // 特権付き初期化時に通常 Initialize 済であっても,特権付きで IPC を開きなおすような処理にはなっていない．
    // windows 上では複数アプリが1バイナリになる関係で,開発者が意図せず，既に通常初期化されている状況になる可能性があるので，
    // 以下のフラグはすべて true にして, windows では ResultNoCapability は発生しないようにしておく．
    const Capability g_AdminCapability = {
        true,  // isArbitraryPrioritySettable
        true,  // isArbitraryPresetSettable
        true,  // isRequirementSettable
        true,  // isRejectableFlagSettable
        true,  // isSustainableFlagSettable
        true,  // isProfileEditable
        true,  // isPassphraseAcquirable
        true,  // isSsidListAcquirable
        true,  // isWirelessCommunicationControllable
        true,  // isRequestEnabledSettable
    };
    const Capability g_SystemCapability = {
        true,  // isArbitraryPrioritySettable
        true,  // isArbitraryPresetSettable
        true,  // isRequirementSettable
        true,  // isRejectableFlagSettable
        true,  // isSustainableFlagSettable
        true,  // isProfileEditable
        true,  // isPassphraseAcquirable
        true,  // isSsidListAcquirable
        true,  // isWirelessCommunicationControllable
        true,  // isRequestEnabledSettable
    };
    const Capability g_UserCapability = {
        true,  // isArbitraryPrioritySettable
        true,  // isArbitraryPresetSettable
        true,  // isRequirementSettable
        true,  // isRejectableFlagSettable
        true,  // isSustainableFlagSettable
        true,  // isProfileEditable
        true,  // isPassphraseAcquirable
        true,  // isSsidListAcquirable
        true,  // isWirelessCommunicationControllable
        true,  // isRequestEnabledSettable
    };
#else
    const Capability g_AdminCapability = {
        true,  // isArbitraryPrioritySettable
        true,  // isArbitraryPresetSettable
        true,  // isRequirementSettable
        true,  // isRejectableFlagSettable
        true,  // isSustainableFlagSettable
        true,  // isProfileEditable
        true,  // isPassphraseAcquirable
        true,  // isSsidListAcquirable
        true,  // isWirelessCommunicationControllable
        true,  // isRequestEnabledSettable
    };
    const Capability g_SystemCapability = {
        true,  // isArbitraryPrioritySettable
        true,  // isArbitraryPresetSettable
        false, // isRequirementSettable
        false, // isRejectableFlagSettable
        true,  // isSustainableFlagSettable
        false, // isProfileEditable
        false, // isPassphraseAcquirable
        false, // isSsidListAcquirable
        true,  // isWirelessCommunicationControllable
        true,  // isRequestEnabledSettable
    };
    const Capability g_UserCapability = {
        false, // isArbitraryPrioritySettable
        false, // isArbitraryPresetSettable
        false, // isRequirementSettable
        false, // isRejectableFlagSettable
        false, // isSustainableFlagSettable
        false, // isProfileEditable
        false, // isPassphraseAcquirable
        false, // isSsidListAcquirable
        false, // isWirelessCommunicationControllable
        false, // isRequestEnabledSettable
    };
#endif


#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC

HipcServerManager::HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT
    : m_SfExpHeapAllocator(nn::lmem::CreationOption_NoOption),
      m_AdminStaticService(pServiceProvider, g_AdminCapability, m_SfExpHeapAllocator.GetBase()),
      m_SystemStaticService(pServiceProvider, g_SystemCapability, m_SfExpHeapAllocator.GetBase()),
      m_UserStaticService(pServiceProvider, g_UserCapability, m_SfExpHeapAllocator.GetBase()),
      m_pPowerStateCoordinator(&pServiceProvider->m_PowerStateCoordinator)
{
    // サービス名の登録とポートの初期化
    RegisterObjectForPort(m_AdminStaticService.GetShared(), 2, AdminServiceName);     // ネット接続アプレット
    RegisterObjectForPort(m_SystemStaticService.GetShared(), 16, SystemServiceName);  // システムプロセス，アプレット
    RegisterObjectForPort(m_UserStaticService.GetShared(),  5, UserServiceName);      // アプリ，アプレット

    // サーバマネージャの開始
    // ただし、実際のサーバ動作は、LoopAuto 関数等を呼び出すことで行う必要がある
    Start();
}

HipcServerManager::~HipcServerManager() NN_NOEXCEPT
{
}

void HipcServerManager::MyLoopAuto() NN_NOEXCEPT
{
    SingleSystemEventHandler& powerStateEventHandler = m_pPowerStateCoordinator->GetPowerStateEventHandler();

    HipcSimpleAllInOneServerManager::AddUserWaitHolder(powerStateEventHandler.GetMultiWaitHolderPointer());

    for (;;)
    {
        nn::os::MultiWaitHolderType* pHolder = Wait();

        if (powerStateEventHandler.ExecuteCallbackIfSignaled(pHolder))
        {
            NN_DETAIL_NIFM_INFO("Handled a power state event.\n");
            HipcSimpleAllInOneServerManager::AddUserWaitHolder(powerStateEventHandler.GetMultiWaitHolderPointer());
        }
        else
        {
            HipcSimpleAllInOneServerManager::ProcessAuto(pHolder);
        }
    }
}

#endif

}
}
}
