﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/core/nifm_TelemetryContext.h>
#include <nnc/result/result_CConverter.h>

namespace nn
{
namespace nifm
{
namespace detail
{

TelemetryContext::TelemetryContext() NN_NOEXCEPT
    : m_SystemEvent(nn::os::EventClearMode_ManualClear, true)
{
}

TelemetryContext::~TelemetryContext() NN_NOEXCEPT
{
}

void TelemetryContext::SetResult(Result result) NN_NOEXCEPT
{
    m_Result = result;
}

void TelemetryContext::SetNetworkProfile(const nn::util::optional<NetworkProfileData>& networkProfileData) NN_NOEXCEPT
{
    m_NetworkProfileData = networkProfileData;

}

void TelemetryContext::SetAccessPoint(const nn::util::optional<AccessPointData>& accessPointData) NN_NOEXCEPT
{
    m_AccessPointData = accessPointData;
}

void TelemetryContext::SetWirelessMacAddress(const nn::util::optional<MacAddress>& macAddress) NN_NOEXCEPT
{
    m_WirelessMacAddress = macAddress;
}

void TelemetryContext::SetEthernetMacAddress(const nn::util::optional<MacAddress>& macAddress) NN_NOEXCEPT
{
    m_EthernetMacAddress = macAddress;
}

void TelemetryContext::SetIpConfig(const nn::util::optional<IpAddressSetting>& ipAddressSetting, const nn::util::optional<DnsSetting>& dnsSetting) NN_NOEXCEPT
{
    m_IpAddressSetting = ipAddressSetting;
    m_DnsSetting = dnsSetting;
}

void TelemetryContext::SetSsidListVersion(const nn::util::optional<SsidListVersion>& ssidListVersion) NN_NOEXCEPT
{
    m_SsidListVersion = ssidListVersion;
}

void TelemetryContext::SetAdditionalInfo(const nn::util::optional<AdditionalInfo>& additionalInfo) NN_NOEXCEPT
{
    m_AdditionalInfo = additionalInfo;
}

void TelemetryContext::Signal() NN_NOEXCEPT
{
    m_SystemEvent.Signal();
}

nn::os::NativeHandle TelemetryContext::GetSystemEventReadableHandle() NN_NOEXCEPT
{
    return m_SystemEvent.GetReadableHandle();
}

void TelemetryContext::GetTelemetryInfo(TelemetryInfo* pOutTelemetryInfo) NN_NOEXCEPT
{
    pOutTelemetryInfo->result = nn::result::ConvertToC(m_Result);

    if (m_NetworkProfileData)
    {
        pOutTelemetryInfo->networkProfileData = *m_NetworkProfileData;
    }
    if (m_AccessPointData)
    {
        pOutTelemetryInfo->accessPointData = *m_AccessPointData;
    }
    if (m_DnsSetting)
    {
        pOutTelemetryInfo->dnsSetting = *m_DnsSetting;
    }
    if (m_IpAddressSetting)
    {
        pOutTelemetryInfo->ipAddressSetting = *m_IpAddressSetting;
    }
    if (m_EthernetMacAddress)
    {
        pOutTelemetryInfo->ethernetMacAddress = *m_EthernetMacAddress;
    }
    if (m_WirelessMacAddress)
    {
        pOutTelemetryInfo->wirelessMacAddress = *m_WirelessMacAddress;
    }
    if (m_SsidListVersion)
    {
        pOutTelemetryInfo->ssidListVersion = *m_SsidListVersion;
    }
    if (m_AdditionalInfo)
    {
        pOutTelemetryInfo->additionalInfo = *m_AdditionalInfo;
    }

    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::ConnectionStatusInfo::Index, m_NetworkProfileData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::AccessPointInfo::Index, m_AccessPointData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::RadioStrengthInfo::Index, m_AccessPointData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::WirelessAPMacAddressInfo::Index, m_AccessPointData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::StealthNetworkInfo::Index, m_NetworkProfileData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::NXMacAddressInfo::Index, m_WirelessMacAddress);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::LANAdapterMacAddressInfo::Index, m_EthernetMacAddress);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::NetworkInfo::Index, m_NetworkProfileData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::NetworkInfoIpAddressSetting::Index, m_IpAddressSetting);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::NetworkInfoDnsSetting::Index, m_DnsSetting);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::LimitHighCapacityInfo::Index, m_NetworkProfileData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::NintendoZoneConnectedInfo::Index, m_NetworkProfileData);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::NintendoZoneSSIDListVersionInfo::Index, m_SsidListVersion);
    pOutTelemetryInfo->flagSet.Set(TelemetryFlag::ConnectionTestInfo::Index, m_AdditionalInfo);
}

}
}
}

