﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpResponse.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/result/result_HandlingUtility.h>

#include <cstring>
#include <algorithm>

namespace nn
{
namespace nifm
{
namespace detail
{

HttpResponse::HttpResponse() NN_NOEXCEPT
    : m_Length(0)
{
}

HttpResponse::~HttpResponse() NN_NOEXCEPT
{
}

int HttpResponse::Add(const char* pContent, int size) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pContent);

    auto writeSize = std::min(Size - m_Length - 1, size);
    NN_SDK_ASSERT(writeSize >= 0);

    std::memcpy(&m_Buffer[m_Length], pContent, writeSize);
    m_Length += writeSize;
    m_Buffer[m_Length] = '\0';

    return writeSize;
}

const char* HttpResponse::GetPointer() const NN_NOEXCEPT
{
    return m_Buffer;
}

int HttpResponse::GetLength() const NN_NOEXCEPT
{
    return m_Length;
}

void HttpResponse::Clear() NN_NOEXCEPT
{
    m_Buffer[0] = '\0';
    m_Length = 0;
}

}
}
}
