﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/core/accessPoint/nifm_EthernetAccessPoint.h>

#include <nn/nifm/detail/core/networkInterface/nifm_EthernetInterface.h>


namespace nn
{
namespace nifm
{
namespace detail
{

EthernetAccessPoint::EthernetAccessPoint(EthernetInterface* pEthernetInterface) NN_NOEXCEPT
    : AccessPointBase(pEthernetInterface)
{
}

EthernetAccessPoint::~EthernetAccessPoint() NN_NOEXCEPT
{
}

nn::Result EthernetAccessPoint::ConnectImpl(
    const NetworkProfileBase& networkProfile,
    const AggregatedRequestType& aggregatedRequest) const NN_NOEXCEPT
{
    NN_RESULT_THROW(static_cast<EthernetInterface*>(m_pNetworkInterfaceBase)->ConnectImpl(*this, networkProfile, aggregatedRequest));
}

nn::Result EthernetAccessPoint::DisconnectImpl() const NN_NOEXCEPT
{
    NN_RESULT_THROW(static_cast<EthernetInterface*>(m_pNetworkInterfaceBase)->DisconnectImpl(*this));
}

nn::Result EthernetAccessPoint::ReleaseImpl() const NN_NOEXCEPT
{
    NN_RESULT_THROW(static_cast<EthernetInterface*>(m_pNetworkInterfaceBase)->ReleaseImpl(*this));
}

void EthernetAccessPoint::UpdateAccessPoint(
    const NetworkProfileBase& networkProfile) NN_NOEXCEPT
{
    static_cast<EthernetInterface*>(m_pNetworkInterfaceBase)->UpdateAccessPoint(this, networkProfile);
}

AccessPointBase* EthernetAccessPoint::CopyTo(void* p, size_t size) const NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(p);
    NN_SDK_ASSERT_GREATER_EQUAL(size, sizeof(*this));
    NN_UNUSED(size);

    return new(p) EthernetAccessPoint(*this);
}

size_t EthernetAccessPoint::GetSize() const NN_NOEXCEPT
{
    return sizeof(*this);
}

bool EthernetAccessPoint::operator==(const AccessPointBase& rh) const NN_NOEXCEPT
{
    return rh == *this;
}

}
}
}
