﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "./ngc_ErrnoT.h"

namespace nn { namespace ngc { namespace detail {

nn::ngc::detail::errno_t SwapEndian16(uint16_t* p, size_t count)
{
    uint16_t* pend = p + count;
    while (p != pend)
    {
#ifdef _MSC_VER
        *p = _byteswap_ushort(*p);
#else
        *p = ((*p & 0xFF) << 8) | ((*p >> 8) & 0xFF);
#endif
        ++p;
    }
    return 0;
}

nn::ngc::detail::errno_t SwapEndian32(uint32_t* p, size_t count)
{
    uint32_t* pend = p + count;
    while (p != pend)
    {
#ifdef _MSC_VER
        *p = _byteswap_ulong(*p);
#else
        *p = __builtin_bswap32(*p);
#endif
        ++p;
    }
    return 0;
}

nn::ngc::detail::errno_t SwapEndian64(uint64_t* p, size_t count)
{
    uint64_t* pend = p + count;
    while (p != pend)
    {
#ifdef _MSC_VER
        *p = _byteswap_uint64(*p);
#else
        *p = __builtin_bswap64(*p);
#endif
        ++p;
    }
    return 0;
}

const unsigned char PopCntArray[256] = {
    0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8
};

}}} // nn::ngc::detail
