﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_Language.h>

namespace nn {
namespace ngc {
namespace detail {

    /*!--------------------------------------------------------------------------*
      Name:         GetLanguageSetting

      @brief        本体とアプリケーションの言語設定に対応するパターンリストを取得します。
      @return       本体とアプリケーションの言語設定に対応するパターンリストを取得しますパターンリストを返します。
                    対応するパターンリストが見つからない場合は0が返ります。
     *---------------------------------------------------------------------------*/
    Bit32 GetLanguageSetting(bool checkDesiredLanguage) NN_NOEXCEPT;

}
}
}
