﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nfp/nfp_Types.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateResult.h>

namespace nn { namespace nfp { namespace server {

class ScopedFileStreamOpen
{
public:
    explicit ScopedFileStreamOpen(int* fileHandle) NN_NOEXCEPT;
    ~ScopedFileStreamOpen() NN_NOEXCEPT;
    nn::Result Initialize(const char* pathName, int openMode) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Release() NN_NOEXCEPT;
private:
    int* m_FileHandle;
    bool m_IsReleased;
};

}}}  // namespace nn::nfp::server
