﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nfc/server/core/nfc_SaveData.h>
#include "nfp_ScopedFileStreamOpen.h"
#include "nfp_Util.h"

namespace nn {
namespace nfp {
namespace server {

ScopedFileStreamOpen::ScopedFileStreamOpen(int* fileHandle) NN_NOEXCEPT : m_FileHandle(fileHandle), m_IsReleased(true)
{
}

ScopedFileStreamOpen::~ScopedFileStreamOpen() NN_NOEXCEPT
{
    Finalize();
}

nn::Result ScopedFileStreamOpen::Initialize(const char* pathName, int openMode) NN_NOEXCEPT
{
    NN_RESULT_DO(nn::nfc::server::core::SaveData::GetInstance().Open(m_FileHandle, pathName, openMode));
    m_IsReleased = false;
    NN_RESULT_SUCCESS;
}

void ScopedFileStreamOpen::Finalize() NN_NOEXCEPT
{
    if(!m_IsReleased)
    {
        nn::nfc::server::core::SaveData::GetInstance().Close(*m_FileHandle);
        m_IsReleased = true;
    }
}

void ScopedFileStreamOpen::Release() NN_NOEXCEPT
{
    m_IsReleased = true;
}

} // end of namespace server
} // end of namespace nfp
} // end of namespace nn
