﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfc/server/nfc_Tag.h>

namespace nn { namespace nfp { namespace server {

class Ntag : public nn::nfc::server::Tag
{
public:
    static bool IsNtag(nn::nfc::NfcProtocol protocol, nn::nfc::TagType type) NN_NOEXCEPT;
    Ntag(const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::TagId& id, nn::os::SystemEventType* accessFinishEvent, nn::os::SystemEventType* accessResetEvent) NN_NOEXCEPT;
    virtual ~Ntag() NN_NOEXCEPT;
    nn::Result Read(nn::nfc::server::core::NtagData* ntagData, nn::nfc::server::core::Service* service, const nn::nfc::server::core::NtagReadParameter& ntagReadParameter) NN_NOEXCEPT;
    nn::Result Write(nn::nfc::server::core::Service* service, const nn::nfc::server::core::NtagWriteParameter& ntagWriteParameter) NN_NOEXCEPT;
    nn::Result Read(void* pOutBuffer, nn::nfc::server::core::Service* service, uint16_t  timeoutMsec, bool isPasswordRequired, uint8_t startPage, uint8_t endPage, size_t bufferSize) NN_NOEXCEPT;
    nn::Result Write(nn::nfc::server::core::Service* service, uint16_t  timeoutMsec, bool isPasswordRequired, bool isActivationNeeded, const void* clearData, const void* activationData, size_t activationDataSize, uint8_t startPage, uint8_t endPage, const void* pData, size_t dataSize) NN_NOEXCEPT;
    nn::Result ReadyToWrite(nn::nfc::server::core::Service* service, bool isPasswordRequired) NN_NOEXCEPT;
    nn::Result SendFastReadCommand(void* pOutBuffer, nn::nfc::server::core::Service* service, uint8_t startPage, uint8_t endPage, size_t bufferSize) NN_NOEXCEPT;
    nn::Result SendWriteCommand(nn::nfc::server::core::Service* service, uint8_t page, const void* pData, size_t dataSize) NN_NOEXCEPT;
    nn::Result SendWriteCommandAndVerify(nn::nfc::server::core::Service* service, uint8_t page, const void* pData, size_t dataSize) NN_NOEXCEPT;

private:
    Ntag() NN_NOEXCEPT;

protected:
    uint8_t m_Type2TagVersion;

};

}}}  // namespace nn::nfp::server
