﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "nfp_Keys.h"

namespace nn {
namespace nfp {
namespace server {

    class Crypto
    {
    public:
        static const size_t PrfSeedSize = 64;
        static const size_t HashSize = 32;
        static const size_t HmacSize = HashSize;

    private:
        static void CalculateHmacSha256(void* pOutHmac, size_t hmacSize, const void* pData, size_t dataSize, const void* pKey, size_t keySize) NN_NOEXCEPT;
        static void CalculateSha256Prf(Keys* pOutKeys, const void* pKey, size_t keySize, const char* pLabel, const void* pSeed, size_t seedSize) NN_NOEXCEPT;
        static void CalculateHmacSha256Vector(void* pOutHmac, size_t hmacSize,
                                              const void* pKey, size_t keySize,
                                              size_t elementNum, const void* element[], const size_t elementLen[]) NN_NOEXCEPT;

    public:
        static void CalculateSha256(void* pOutHash, size_t hashSize, const void* pData, size_t dataSize) NN_NOEXCEPT;
        static void SignHmacSha256(void* pOutHmac, size_t hmacSize, const void* pData, size_t dataSize, void* pKey, size_t keySize) NN_NOEXCEPT;
        static void CalculateKey(Keys* pOutKeys, const void* pSeed, size_t seedSize, bool isWrite) NN_NOEXCEPT;
        static void EncryptAndDecryptAesCtr(void* pOutBuffer, size_t bufferSize, const void* pData, size_t dataSize, void* pKey, size_t keySize, void* pIv, size_t ivSize) NN_NOEXCEPT;
        static void DecryptNtf(void* pOutBuffer, size_t bufferSize, const void* pData, size_t dataSize) NN_NOEXCEPT;
    };

} // end of namespace server
} // end of namespace nfp
} // end of namespace nn
