﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfp/nfp_NpadApi.h>
#include "client/nfp_CommonInterface.h"
#include "detail/nfp_Util.h"

namespace nn { namespace nfp {

nn::Result GetNpadId(nn::hid::NpadIdType* pOutNpadId, const DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutNpadId);

    NN_NFP_DETAIL_RETURN(NN_NFP_CLIENT_GET_COMMON_INTERFACE(GetNpadId, (pOutNpadId, reinterpret_cast<const nn::nfc::DeviceHandle&>(deviceHandle))));
}

}}
