﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkAssert.h>
#include "client/nfp_CommonInterface.h"
#include "detail/nfp_AmiiboSettings.h"
#include <nn/nfp/nfp_AmiiboSettingsApi.h>

namespace nn { namespace nfp {

nn::Result StartNicknameAndOwnerSettings(DeviceHandle* pOutDeviceHandle, bool* pOutIsRegistered, RegisterInfo* pOutRegisterInfo, const AmiiboSettingsStartParam& startParam, const TagInfo& tagInfo, const RegisterInfo& registerInfo) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutDeviceHandle);
    NN_SDK_REQUIRES_NOT_NULL(pOutIsRegistered);
    NN_SDK_REQUIRES_NOT_NULL(pOutRegisterInfo);

    NN_SDK_REQUIRES(NN_NFP_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_SYSTEM());

    StartParamForAmiiboSettings* param;
    ReturnValueForAmiiboSettings* value;

    std::lock_guard<nn::os::Mutex> lock(nn::nfp::detail::RefMutexForAmiiboSettings());
    nn::nfp::detail::GetBufferForAmiiboSettings(&value, &param);

    std::memset(param, 0, sizeof(*param));
    param->version = nn::nfp::detail::StartParamVersionForAmiiboSettings;
    param->mode = static_cast<nn::Bit8>(AmiiboSettingsMode_NicknameAndOwnerSettings);
    param->infoFlags = static_cast<nn::Bit8>(AmiiboSettingsInfoFlags_DeviceHandle | AmiiboSettingsInfoFlags_TagInfo | AmiiboSettingsInfoFlags_RegisterInfo);
    param->optionFlags = startParam.optionFlags;
    param->deviceHandle = startParam.deviceHandle;
    param->tagInfo = tagInfo;
    param->registerInfo = registerInfo;
    std::memcpy(param->_debug, startParam._debug, sizeof(param->_debug));

    NN_RESULT_DO(nn::nfp::detail::StartAmiiboSettings(value, *param));

    *pOutDeviceHandle = value->deviceHandle;
    *pOutIsRegistered = ((value->infoFlags & AmiiboSettingsInfoFlags_RegisterInfo) != 0);
    if(*pOutIsRegistered)
    {
        *pOutRegisterInfo = value->registerInfo;
    }

    NN_RESULT_SUCCESS;
}

nn::Result StartNicknameAndOwnerSettings(DeviceHandle* pOutDeviceHandle, bool* pOutIsRegistered, RegisterInfo* pOutRegisterInfo, const AmiiboSettingsStartParam& startParam, const TagInfo& tagInfo) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutDeviceHandle);
    NN_SDK_REQUIRES_NOT_NULL(pOutIsRegistered);
    NN_SDK_REQUIRES_NOT_NULL(pOutRegisterInfo);

    NN_SDK_REQUIRES(NN_NFP_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_SYSTEM());

    StartParamForAmiiboSettings* param;
    ReturnValueForAmiiboSettings* value;

    std::lock_guard<nn::os::Mutex> lock(nn::nfp::detail::RefMutexForAmiiboSettings());
    nn::nfp::detail::GetBufferForAmiiboSettings(&value, &param);

    std::memset(param, 0, sizeof(*param));
    param->version = nn::nfp::detail::StartParamVersionForAmiiboSettings;
    param->mode = static_cast<nn::Bit8>(AmiiboSettingsMode_NicknameAndOwnerSettings);
    param->infoFlags = static_cast<nn::Bit8>(AmiiboSettingsInfoFlags_DeviceHandle | AmiiboSettingsInfoFlags_TagInfo);
    param->optionFlags = startParam.optionFlags;
    param->deviceHandle = startParam.deviceHandle;
    param->tagInfo = tagInfo;
    std::memcpy(param->_debug, startParam._debug, sizeof(param->_debug));

    NN_RESULT_DO(nn::nfp::detail::StartAmiiboSettings(value, *param));

    *pOutDeviceHandle = value->deviceHandle;
    *pOutIsRegistered = ((value->infoFlags & AmiiboSettingsInfoFlags_RegisterInfo) != 0);
    if(*pOutIsRegistered)
    {
        *pOutRegisterInfo = value->registerInfo;
    }

    NN_RESULT_SUCCESS;
}

nn::Result StartGameDataEraser(DeviceHandle* pOutDeviceHandle, const AmiiboSettingsStartParam& startParam, const TagInfo& tagInfo) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutDeviceHandle);

    NN_SDK_REQUIRES(NN_NFP_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_SYSTEM());

    StartParamForAmiiboSettings* param;
    ReturnValueForAmiiboSettings* value;

    std::lock_guard<nn::os::Mutex> lock(nn::nfp::detail::RefMutexForAmiiboSettings());
    nn::nfp::detail::GetBufferForAmiiboSettings(&value, &param);

    std::memset(param, 0, sizeof(*param));
    param->version = nn::nfp::detail::StartParamVersionForAmiiboSettings;
    param->mode = static_cast<nn::Bit8>(AmiiboSettingsMode_GameDataEraser);
    param->infoFlags = static_cast<nn::Bit8>(AmiiboSettingsInfoFlags_DeviceHandle | AmiiboSettingsInfoFlags_TagInfo);
    param->optionFlags = startParam.optionFlags;
    param->deviceHandle = startParam.deviceHandle;
    param->tagInfo = tagInfo;
    std::memcpy(param->_debug, startParam._debug, sizeof(param->_debug));

    NN_RESULT_DO(nn::nfp::detail::StartAmiiboSettings(value, *param));

    *pOutDeviceHandle = value->deviceHandle;

    NN_RESULT_SUCCESS;
}

nn::Result StartRestorer(DeviceHandle* pOutDeviceHandle, const AmiiboSettingsStartParam& startParam, const TagInfo& tagInfo) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutDeviceHandle);

    NN_SDK_REQUIRES(NN_NFP_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_SYSTEM());

    StartParamForAmiiboSettings* param;
    ReturnValueForAmiiboSettings* value;

    std::lock_guard<nn::os::Mutex> lock(nn::nfp::detail::RefMutexForAmiiboSettings());
    nn::nfp::detail::GetBufferForAmiiboSettings(&value, &param);

    std::memset(param, 0, sizeof(*param));
    param->version = nn::nfp::detail::StartParamVersionForAmiiboSettings;
    param->mode = static_cast<nn::Bit8>(AmiiboSettingsMode_Restorer);
    param->infoFlags = static_cast<nn::Bit8>(AmiiboSettingsInfoFlags_DeviceHandle | AmiiboSettingsInfoFlags_TagInfo);
    param->optionFlags = startParam.optionFlags;
    param->deviceHandle = startParam.deviceHandle;
    param->tagInfo = tagInfo;
    std::memcpy(param->_debug, startParam._debug, sizeof(param->_debug));

    NN_RESULT_DO(nn::nfp::detail::StartAmiiboSettings(value, *param));

    *pOutDeviceHandle = value->deviceHandle;

    NN_RESULT_SUCCESS;
}

}}
