﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/nfp/detail/nfp_IUser.h>

namespace nn {
namespace nfp {
namespace client {

void CreateUserInterface() NN_NOEXCEPT;
nn::sf::SharedPointer<nn::nfp::detail::IUser>GetUserInterfaceForCommon() NN_NOEXCEPT;
nn::sf::SharedPointer<nn::nfp::detail::IUser>GetUserInterface() NN_NOEXCEPT;
void DestroyUserInterface() NN_NOEXCEPT;
bool IsCreatedUserInterface() NN_NOEXCEPT;

}  // client
}  // nfp
}  // nn
