﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>

#include <nn/nfp/detail/nfp_Port.h>
#include <nn/nfp/detail/nfp_IDebug.h>    // for IDebug
#include "../detail/nfp_Util.h"
#ifdef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
#include <nn/nfp/server/nfp_CreateDebugManagerByDfc.h>
#endif

namespace nn { namespace nfp { namespace client {

namespace {

#ifndef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateDebugManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateDebugManagerByHipcTag> DebugAllocator;

nn::sf::HipcSimpleClientSessionManager g_DebugDomain;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class DebugAllocatorInitializer
{
public:

    DebugAllocatorInitializer() NN_NOEXCEPT
    {
        DebugAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_DebugAllocatorInitializer;

nn::sf::SharedPointer<nn::nfp::detail::IDebugManager> CreateDebugManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::nfp::detail::IDebugManager> pAccessor;
    auto result = g_DebugDomain.InitializeByName<nn::nfp::detail::IDebugManager, DebugAllocator::Policy>(&pAccessor, nn::nfp::detail::DebugPortName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_DebugDomain.SetSessionCount(nn::nfp::detail::DebugSessionCount));
    NN_SDK_ASSERT(pAccessor);
    return pAccessor;
}
#endif

nn::sf::SharedPointer<nn::nfp::detail::IDebug> g_RefDebugInterface = nullptr;

}

void CreateDebugInterface() NN_NOEXCEPT
{
#ifndef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    auto pAccessor = CreateDebugManagerByHipc();
#else
    auto pAccessor = nn::nfp::server::CreateDebugManagerByDfc();
#endif
    pAccessor->CreateDebugInterface(&g_RefDebugInterface);
    NN_SDK_ASSERT(g_RefDebugInterface);
    pAccessor = nullptr;
}

nn::sf::SharedPointer<nn::nfp::detail::IDebug>GetDebugInterface() NN_NOEXCEPT
{
    NN_NFP_DETAIL_REQUIRES_INITIALIZED_DEBUG(g_RefDebugInterface);
    return g_RefDebugInterface;
}

void DestroyDebugInterface() NN_NOEXCEPT
{
    g_RefDebugInterface = nullptr;
#ifndef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    g_DebugDomain.Finalize();
#endif
}

bool IsCreatedDebugInterface() NN_NOEXCEPT
{
    return (g_RefDebugInterface != nullptr);
}

}}}
