﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/server/util/nfc_ScopedMutexLock.h>

namespace nn { namespace nfc { namespace server { namespace util {

ScopedMutexLock::ScopedMutexLock(nn::os::MutexType& mutex) NN_NOEXCEPT : m_mutex(mutex), m_IsLocked(false)
{
    nn::os::LockMutex(&m_mutex);
    m_IsLocked = true;
}

void ScopedMutexLock::Lock() NN_NOEXCEPT
{
    nn::os::LockMutex(&m_mutex);
    m_IsLocked = true;
}

void ScopedMutexLock::Unlock() NN_NOEXCEPT
{
    m_IsLocked = false;
    nn::os::UnlockMutex(&m_mutex);
}

ScopedMutexLock::~ScopedMutexLock() NN_NOEXCEPT
{
    if(m_IsLocked)
    {
        nn::os::UnlockMutex(&m_mutex);
    }
}

}}}}  // namespace nn::nfc::server::util
