﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nn_SdkLog.h>
#include <nn/xcd/xcd.h>
#include "nfc_Ntag.h"
#include "nfc_LocalUtil.h"
#include <nn/nfc/server/util/nfc_ScopedMutexLock.h>

namespace nn { namespace nfc { namespace server { namespace core {

namespace
{
}

nn::Result Ntag::StartRead(const NtagReadParameter& ntagReadParameter) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return StartNtagReadWithRetry(ntagReadParameter, m_XcdDeviceHandle);
}

nn::Result Ntag::StartWrite(const NtagWriteParameter& ntagWriteParameter) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return StartNtagWriteWithRetry(ntagWriteParameter, m_XcdDeviceHandle);
}

}}}}  // namespace nn::nfc::server::core
