﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/server/core/nfc_DeviceEvent.h>
#include <nn/nfc/server/util/nfc_UtilUtil.h>

namespace nn { namespace nfc { namespace server { namespace core {

namespace
{

}

DeviceEvent::DeviceEvent() NN_NOEXCEPT : m_IsInitialized(false)
{
}

DeviceEvent::~DeviceEvent() NN_NOEXCEPT
{
    if(IsInitialized())
    {
        Finalize();
    }
}

void DeviceEvent::Initialize(const nn::nfc::DeviceHandle& handle) NN_NOEXCEPT
{
    m_Handle = handle;
    nn::os::CreateSystemEvent(&m_ActivateEvent,
                              nn::os::EventClearMode_ManualClear,
                              true);
    nn::os::CreateSystemEvent(&m_DeactivateEvent,
                              nn::os::EventClearMode_ManualClear,
                              true);
    m_IsInitialized = true;
}


void DeviceEvent::Finalize() NN_NOEXCEPT
{
    nn::os::DestroySystemEvent(&m_ActivateEvent);
    nn::os::DestroySystemEvent(&m_DeactivateEvent);
    m_IsInitialized = false;
}

bool DeviceEvent::IsInitialized() NN_NOEXCEPT
{
    return m_IsInitialized;
}

bool DeviceEvent::IsEqual(const nn::nfc::DeviceHandle& handle) NN_NOEXCEPT
{
    return nn::nfc::server::util::IsEqualDeviceHandle(m_Handle, handle);
}

nn::os::SystemEventType& DeviceEvent::GetActivateEvent() NN_NOEXCEPT
{
    return m_ActivateEvent;
}

nn::os::SystemEventType& DeviceEvent::GetDeactivateEvent() NN_NOEXCEPT
{
    return m_DeactivateEvent;
}

}}}}  // namespace nn::nfc::server::core
