﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <memory>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/system/hid_Result.h>
#include <nn/nfc/server/core/nfc_CoreUtil.h>

namespace nn { namespace nfc { namespace server { namespace core {

namespace
{
}

nn::Result ConvertToNfcResult(nn::xcd::NfcResultCode resultCode) NN_NOEXCEPT
{
    switch(resultCode)
    {
    case nn::xcd::NfcResultCode_Ok:
        {
            NN_RESULT_SUCCESS;
        }
    case nn::xcd::NfcResultCode_FunctionError:
        {
            return nn::nfc::ResultNfcDeviceError();
        }
    case nn::xcd::NfcResultCode_ResetRequired:
        {
            return nn::nfc::ResultNeedRetry();
        }
    case nn::xcd::NfcResultCode_ReadError:
        {
            return nn::nfc::ResultNeedRetry();
        }
    case nn::xcd::NfcResultCode_WriteError:
        {
            return nn::nfc::ResultOperationFailed();
        }
    case nn::xcd::NfcResultCode_ArgumentError:
        {
            return nn::nfc::ResultInvalidDeviceState();
        }
    case nn::xcd::NfcResultCode_Timeout:
        {
            return nn::nfc::ResultInvalidDeviceState();
        }
    case nn::xcd::NfcResultCode_InvalidUid:
        {
            return nn::nfc::ResultUidMisMatch();
        }
    case nn::xcd::NfcResultCode_Type2PasswordInvalidTag:
        {
            //パスワードを7回以上失敗したタグ
            return nn::nfc::ResultAuthenticationError();
        }
    case nn::xcd::NfcResultCode_VerifyError:
        {
            return nn::nfc::ResultOperationFailed();
        }
    case nn::xcd::NfcResultCode_ActivationError:
        {
            return nn::nfc::ResultOperationFailed();
        }
    case nn::xcd::NfcResultCode_InvalidTag:
        {
            return nn::nfc::ResultInvalidTag();
        }
    case nn::xcd::NfcResultCode_InvalidFormat:
        {
            //NFP以外のタグ
            // - Type 2 (NTAG 215 BLANK)
            // - Type 2 (NTAG 216)
            //システム領域 (CC領域) が異なる NFP タグ
            return nn::nfc::ResultInvalidTag();
        }
    case nn::xcd::NfcResultCode_AuthenticationError:
        {
            //パスワード違いのNFPタグ
            return nn::nfc::ResultInvalidTag();
        }
    case nn::xcd::NfcResultCode_SequenceError:
        {
            return nn::nfc::ResultInvalidDeviceState();
        }
    case nn::xcd::NfcResultCode_CommandTimeout:
        {
            return nn::nfc::ResultTimeOutError();
        }
    case nn::xcd::NfcResultCode_MifareError:
        {
            return nn::nfc::ResultNeedRetry();
        }
    default: NN_UNEXPECTED_DEFAULT;
    }
}

nn::Result ConvertToNfcResult(nn::nfc::server::core::ResetReason reason) NN_NOEXCEPT
{
    switch(reason)
    {
    case nn::nfc::server::core::ResetReason_NfcDisabled:
        {
            return nn::nfc::ResultNfcDisabled();
        }
    case nn::nfc::server::core::ResetReason_Sleep:
        {
            return nn::nfc::ResultSleep();
        }
    case nn::nfc::server::core::ResetReason_NotForeground:
        {
            return nn::nfc::ResultNotForeground();
        }
    case nn::nfc::server::core::ResetReason_NfcDeviceNotFound:
        {
            return nn::nfc::ResultNfcDeviceNotFound();
        }
    default: NN_UNEXPECTED_DEFAULT;
    }
}

}}}}  // namespace nn::nfc::server::core
