﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/nfc_TagApi.h>
#include <nn/nfc/nfc_EventApi.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>
#include <nn/nfc/client/nfc_CommonInterface.h>
#include "detail/nfc_Util.h"

namespace nn { namespace nfc {

namespace
{
}

nn::Result ListDevices(nn::nfc::DeviceHandle* pOutBuffer, int* pOutCount, int bufferCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutBuffer);
    NN_SDK_REQUIRES_NOT_NULL(pOutCount);
    NN_SDK_REQUIRES(0 < bufferCount);

    int32_t count;
    nn::sf::OutArray<nn::nfc::DeviceHandle> devices(pOutBuffer, bufferCount);
    NN_RESULT_DO(NN_NFC_CLIENT_GET_COMMON_INTERFACE(ListDevices, (devices, &count)));
    *pOutCount = static_cast<int>(count);

    NN_RESULT_SUCCESS;
}

nn::Result StartDetection(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    return StartDetection(deviceHandle, NfcProtocol_All);
}

nn::Result StartDetection(const nn::nfc::DeviceHandle& deviceHandle, NfcProtocol protocolFilter) NN_NOEXCEPT
{
    NN_NFC_DETAIL_RETURN(NN_NFC_CLIENT_GET_COMMON_INTERFACE(StartDetection, (deviceHandle, protocolFilter)));
}

nn::Result StopDetection(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    NN_NFC_DETAIL_RETURN(NN_NFC_CLIENT_GET_COMMON_INTERFACE(StopDetection, (deviceHandle)));
}

nn::Result GetTagInfo(TagInfo* pOutTagInfo, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutTagInfo);

    NN_NFC_DETAIL_RETURN(NN_NFC_CLIENT_GET_COMMON_INTERFACE(GetTagInfo, (pOutTagInfo, deviceHandle)));
}

}}
