﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfc/nfc_MifareTypes.h>
#include <nn/nfc/server/nfc_Tag.h>

namespace nn { namespace nfc { namespace mifare { namespace server {

class Mifare : public nn::nfc::server::Tag
{
public:
    static bool IsMifare(nn::nfc::NfcProtocol protocol, nn::nfc::TagType type) NN_NOEXCEPT;
    Mifare(const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::TagId& id, nn::os::SystemEventType* accessFinishEvent, nn::os::SystemEventType* accessResetEvent) NN_NOEXCEPT;
    virtual ~Mifare() NN_NOEXCEPT;
    nn::Result Read(nn::nfc::MifareReadBlockData* pOutBlockData, nn::nfc::server::core::Service* service, const nn::nfc::MifareReadBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT;
    nn::Result Write(nn::nfc::server::core::Service* service, const nn::nfc::MifareWriteBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT;

private:
    Mifare() NN_NOEXCEPT;

};

}}}}  // namespace nn::nfc::mifare::server
