﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#define NN_NFC_DETAIL_REQUIRES_INITIALIZED(sfSharedPointer) NN_SDK_REQUIRES(sfSharedPointer != nullptr, "NFC ライブラリが初期化されていません。")
#define NN_NFC_DETAIL_REQUIRES_INITIALIZED_USER(sfSharedPointer) NN_SDK_REQUIRES(sfSharedPointer != nullptr, "NFC ライブラリが nn::nfc::Initialize() で初期化されていません。")
#define NN_NFC_DETAIL_REQUIRES_INITIALIZED_SYSTEM(sfSharedPointer) NN_SDK_REQUIRES(sfSharedPointer != nullptr, "NFC ライブラリが nn::nfc::InitializeSystem() で初期化されていません。")

#define NN_NFC_DETAIL_RETURN(x) return(nn::nfc::detail::CheckError(x))
#define NN_NFC_DETAIL_RESULT_DO(x) NN_RESULT_DO(nn::nfc::detail::CheckError(x))

namespace nn { namespace nfc { namespace detail {
nn::Result CheckError(const nn::Result& result);
}}}  // namespace nn::nfc::detail
