﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/applet/applet_Types.h>")]
    public struct AppletResourceUserId
    {
    }
}

namespace nn.nfc.am.detail
{
    public interface IAm : IServiceObject
    {
        [MethodId(0)]
        Result
            Initialize(
            );

        [MethodId(1)]
        Result
            Finalize(
            );

        [MethodId(2)]
        Result
            NotifyForegroundApplet(
                nn.applet.AppletResourceUserId aruid
            );
    }

    public interface IAmManager : IServiceObject
    {
        [MethodId(0)]
        Result CreateAmInterface(
            Out<IAm> pOutAmInterface
        );
    }
}
